%% Generated by the Erlang ASN.1 BER compiler. Version: 5.4.2
%% Purpose: Encoding and decoding of the types in X509-ML-DSA-2025.

-module('X509-ML-DSA-2025').
-moduledoc false.
-compile(nowarn_unused_vars).
-dialyzer(no_improper_lists).
-dialyzer(no_match).
-include("X509-ML-DSA-2025.hrl").
-asn1_info([{vsn,'5.4.2'},
            {module,'X509-ML-DSA-2025'},
            {options,[{i,"/var/tmp/portage/dev-lang/erlang-28.3/work/otp-OTP-28.3/lib/public_key/asn1/../src"},
 warnings,ber,errors,
 {cwd,"/var/tmp/portage/dev-lang/erlang-28.3/work/otp-OTP-28.3/lib/public_key/asn1"},
 {outdir,"/var/tmp/portage/dev-lang/erlang-28.3/work/otp-OTP-28.3/lib/public_key/asn1/../src"},
 der,noobj,asn1config,
 {i,"."},
 {i,"/var/tmp/portage/dev-lang/erlang-28.3/work/otp-OTP-28.3/lib/public_key/asn1"}]}]).

-export([encoding_rule/0,maps/0,bit_string_format/0,
         legacy_erlang_types/0]).
-export(['dialyzer-suppressions'/1]).
-export([
'enc_ML-DSA-44-PrivateKey'/2,
'enc_ML-DSA-65-PrivateKey'/2,
'enc_ML-DSA-87-PrivateKey'/2,
'enc_ML-DSA-44-PublicKey'/2,
'enc_ML-DSA-65-PublicKey'/2,
'enc_ML-DSA-87-PublicKey'/2
]).

-export([
'dec_ML-DSA-44-PrivateKey'/2,
'dec_ML-DSA-65-PrivateKey'/2,
'dec_ML-DSA-87-PrivateKey'/2,
'dec_ML-DSA-44-PublicKey'/2,
'dec_ML-DSA-65-PublicKey'/2,
'dec_ML-DSA-87-PublicKey'/2
]).

-export([
'enc_pk-ml-dsa-44'/3,
'enc_pk-ml-dsa-65'/3,
'enc_pk-ml-dsa-87'/3,
'enc_sa-ml-dsa-44'/3,
'enc_sa-ml-dsa-65'/3,
'enc_sa-ml-dsa-87'/3,
'enc_sa-ml-dsa-87_smimeCaps'/3,
'enc_sa-ml-dsa-65_smimeCaps'/3,
'enc_sa-ml-dsa-44_smimeCaps'/3
]).

-export([
'dec_pk-ml-dsa-44'/3,
'dec_pk-ml-dsa-65'/3,
'dec_pk-ml-dsa-87'/3,
'dec_sa-ml-dsa-44'/3,
'dec_sa-ml-dsa-65'/3,
'dec_sa-ml-dsa-87'/3,
'dec_sa-ml-dsa-87_smimeCaps'/3,
'dec_sa-ml-dsa-65_smimeCaps'/3,
'dec_sa-ml-dsa-44_smimeCaps'/3
]).

-export([
getenc_PublicKeys/1,
getenc_SignatureAlgorithms/1
]).

-export([
getdec_PublicKeys/1,
getdec_SignatureAlgorithms/1
]).

-export([
nistAlgorithms/0,
sigAlgs/0,
'id-ml-dsa-44'/0,
'id-ml-dsa-65'/0,
'id-ml-dsa-87'/0
]).

-export([info/0]).

-export([encode/2,decode/2]).

encoding_rule() -> ber.

maps() -> false.

bit_string_format() -> bitstring.

legacy_erlang_types() -> false.

encode(Type, Data) ->
try iolist_to_binary(element(1, encode_disp(Type, Data))) of
  Bytes ->
    {ok,Bytes}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.


decode(Type, Data) ->
try
   Result = decode_disp(Type, element(1, ber_decode_nif(Data))),
   {ok,Result}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.

encode_disp('ML-DSA-44-PrivateKey', Data) -> 'enc_ML-DSA-44-PrivateKey'(Data);
encode_disp('ML-DSA-65-PrivateKey', Data) -> 'enc_ML-DSA-65-PrivateKey'(Data);
encode_disp('ML-DSA-87-PrivateKey', Data) -> 'enc_ML-DSA-87-PrivateKey'(Data);
encode_disp('ML-DSA-44-PublicKey', Data) -> 'enc_ML-DSA-44-PublicKey'(Data);
encode_disp('ML-DSA-65-PublicKey', Data) -> 'enc_ML-DSA-65-PublicKey'(Data);
encode_disp('ML-DSA-87-PublicKey', Data) -> 'enc_ML-DSA-87-PublicKey'(Data);
encode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

decode_disp('ML-DSA-44-PrivateKey', Data) -> 'dec_ML-DSA-44-PrivateKey'(Data);
decode_disp('ML-DSA-65-PrivateKey', Data) -> 'dec_ML-DSA-65-PrivateKey'(Data);
decode_disp('ML-DSA-87-PrivateKey', Data) -> 'dec_ML-DSA-87-PrivateKey'(Data);
decode_disp('ML-DSA-44-PublicKey', Data) -> 'dec_ML-DSA-44-PublicKey'(Data);
decode_disp('ML-DSA-65-PublicKey', Data) -> 'dec_ML-DSA-65-PublicKey'(Data);
decode_disp('ML-DSA-87-PublicKey', Data) -> 'dec_ML-DSA-87-PublicKey'(Data);
decode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

info() ->
   case ?MODULE:module_info(attributes) of
     Attributes when is_list(Attributes) ->
       case lists:keyfind(asn1_info, 1, Attributes) of
         {_,Info} when is_list(Info) ->
           Info;
         _ ->
           []
       end;
     _ ->
       []
   end.


%%================================
%%  ML-DSA-44-PrivateKey
%%================================
'enc_ML-DSA-44-PrivateKey'(Val) ->
    'enc_ML-DSA-44-PrivateKey'(Val, []).

'enc_ML-DSA-44-PrivateKey'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      seed ->
         encode_restricted_string(element(2,Val), [<<128>>]);
      expandedKey ->
         encode_restricted_string(element(2,Val), [<<4>>]);
      both ->
         'enc_ML-DSA-44-PrivateKey_both'(element(2,Val), [<<48>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).





%%================================
%%  ML-DSA-44-PrivateKey_both
%%================================
'enc_ML-DSA-44-PrivateKey_both'(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute seed(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<4>>]),

%%-------------------------------------------------
%% attribute expandedKey(2) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_restricted_string(Cindex2, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_ML-DSA-44-PrivateKey'(Tlv) ->
   'dec_ML-DSA-44-PrivateKey'(Tlv, []).

'dec_ML-DSA-44-PrivateKey'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'seed'
    {131072, V1} -> 
        {seed, begin
Val1 = decode_octet_string(V1, []),
C1 = byte_size(Val1),
if C1 =:= 32 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'expandedKey'
    {4, V1} -> 
        {expandedKey, begin
Val2 = decode_octet_string(V1, []),
C2 = byte_size(Val2),
if C2 =:= 2560 ->
Val2;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'both'
    {16, V1} -> 
        {both, 'dec_ML-DSA-44-PrivateKey_both'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.
'dec_ML-DSA-44-PrivateKey_both'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute seed(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_octet_string(V1, [4]),
C1 = byte_size(Val1),
if C1 =:= 32 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute expandedKey(2) with type OCTET STRING
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = begin
Val2 = decode_octet_string(V2, [4]),
C2 = byte_size(Val2),
if C2 =:= 2560 ->
Val2;
true ->
exit({error,{asn1,bad_range}})
end
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'ML-DSA-44-PrivateKey_both',Term1,Term2},
Res1.


%%================================
%%  ML-DSA-65-PrivateKey
%%================================
'enc_ML-DSA-65-PrivateKey'(Val) ->
    'enc_ML-DSA-65-PrivateKey'(Val, []).

'enc_ML-DSA-65-PrivateKey'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      seed ->
         encode_restricted_string(element(2,Val), [<<128>>]);
      expandedKey ->
         encode_restricted_string(element(2,Val), [<<4>>]);
      both ->
         'enc_ML-DSA-65-PrivateKey_both'(element(2,Val), [<<48>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).





%%================================
%%  ML-DSA-65-PrivateKey_both
%%================================
'enc_ML-DSA-65-PrivateKey_both'(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute seed(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<4>>]),

%%-------------------------------------------------
%% attribute expandedKey(2) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_restricted_string(Cindex2, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_ML-DSA-65-PrivateKey'(Tlv) ->
   'dec_ML-DSA-65-PrivateKey'(Tlv, []).

'dec_ML-DSA-65-PrivateKey'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'seed'
    {131072, V1} -> 
        {seed, begin
Val1 = decode_octet_string(V1, []),
C1 = byte_size(Val1),
if C1 =:= 32 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'expandedKey'
    {4, V1} -> 
        {expandedKey, begin
Val2 = decode_octet_string(V1, []),
C2 = byte_size(Val2),
if C2 =:= 4032 ->
Val2;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'both'
    {16, V1} -> 
        {both, 'dec_ML-DSA-65-PrivateKey_both'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.
'dec_ML-DSA-65-PrivateKey_both'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute seed(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_octet_string(V1, [4]),
C1 = byte_size(Val1),
if C1 =:= 32 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute expandedKey(2) with type OCTET STRING
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = begin
Val2 = decode_octet_string(V2, [4]),
C2 = byte_size(Val2),
if C2 =:= 4032 ->
Val2;
true ->
exit({error,{asn1,bad_range}})
end
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'ML-DSA-65-PrivateKey_both',Term1,Term2},
Res1.


%%================================
%%  ML-DSA-87-PrivateKey
%%================================
'enc_ML-DSA-87-PrivateKey'(Val) ->
    'enc_ML-DSA-87-PrivateKey'(Val, []).

'enc_ML-DSA-87-PrivateKey'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      seed ->
         encode_restricted_string(element(2,Val), [<<128>>]);
      expandedKey ->
         encode_restricted_string(element(2,Val), [<<4>>]);
      both ->
         'enc_ML-DSA-87-PrivateKey_both'(element(2,Val), [<<48>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).





%%================================
%%  ML-DSA-87-PrivateKey_both
%%================================
'enc_ML-DSA-87-PrivateKey_both'(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute seed(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<4>>]),

%%-------------------------------------------------
%% attribute expandedKey(2) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_restricted_string(Cindex2, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_ML-DSA-87-PrivateKey'(Tlv) ->
   'dec_ML-DSA-87-PrivateKey'(Tlv, []).

'dec_ML-DSA-87-PrivateKey'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'seed'
    {131072, V1} -> 
        {seed, begin
Val1 = decode_octet_string(V1, []),
C1 = byte_size(Val1),
if C1 =:= 32 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'expandedKey'
    {4, V1} -> 
        {expandedKey, begin
Val2 = decode_octet_string(V1, []),
C2 = byte_size(Val2),
if C2 =:= 4896 ->
Val2;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'both'
    {16, V1} -> 
        {both, 'dec_ML-DSA-87-PrivateKey_both'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.
'dec_ML-DSA-87-PrivateKey_both'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute seed(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_octet_string(V1, [4]),
C1 = byte_size(Val1),
if C1 =:= 32 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute expandedKey(2) with type OCTET STRING
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = begin
Val2 = decode_octet_string(V2, [4]),
C2 = byte_size(Val2),
if C2 =:= 4896 ->
Val2;
true ->
exit({error,{asn1,bad_range}})
end
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'ML-DSA-87-PrivateKey_both',Term1,Term2},
Res1.


%%================================
%%  ML-DSA-44-PublicKey
%%================================
'enc_ML-DSA-44-PublicKey'(Val) ->
    'enc_ML-DSA-44-PublicKey'(Val, [<<4>>]).

'enc_ML-DSA-44-PublicKey'(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


'dec_ML-DSA-44-PublicKey'(Tlv) ->
   'dec_ML-DSA-44-PublicKey'(Tlv, [4]).

'dec_ML-DSA-44-PublicKey'(Tlv, TagIn) ->
begin
Val1 = decode_octet_string(Tlv, TagIn),
C1 = byte_size(Val1),
if C1 =:= 1312 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  ML-DSA-65-PublicKey
%%================================
'enc_ML-DSA-65-PublicKey'(Val) ->
    'enc_ML-DSA-65-PublicKey'(Val, [<<4>>]).

'enc_ML-DSA-65-PublicKey'(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


'dec_ML-DSA-65-PublicKey'(Tlv) ->
   'dec_ML-DSA-65-PublicKey'(Tlv, [4]).

'dec_ML-DSA-65-PublicKey'(Tlv, TagIn) ->
begin
Val1 = decode_octet_string(Tlv, TagIn),
C1 = byte_size(Val1),
if C1 =:= 1952 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  ML-DSA-87-PublicKey
%%================================
'enc_ML-DSA-87-PublicKey'(Val) ->
    'enc_ML-DSA-87-PublicKey'(Val, [<<4>>]).

'enc_ML-DSA-87-PublicKey'(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


'dec_ML-DSA-87-PublicKey'(Tlv) ->
   'dec_ML-DSA-87-PublicKey'(Tlv, [4]).

'dec_ML-DSA-87-PublicKey'(Tlv, TagIn) ->
begin
Val1 = decode_octet_string(Tlv, TagIn),
C1 = byte_size(Val1),
if C1 =:= 2602 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end.

nistAlgorithms() ->
{2,16,840,1,101,3,4}.

sigAlgs() ->
{2,16,840,1,101,3,4,3}.

'id-ml-dsa-44'() ->
{2,16,840,1,101,3,4,3,17}.

'id-ml-dsa-65'() ->
{2,16,840,1,101,3,4,3,18}.

'id-ml-dsa-87'() ->
{2,16,840,1,101,3,4,3,19}.




%%================================
%%  pk-ml-dsa-44
%%================================
'enc_pk-ml-dsa-44'('KeyValue', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_pk-ml-dsa-44'('Params', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_pk-ml-dsa-44'('PrivateKey', Val, _RestPrimFieldName) ->
   'enc_ML-DSA-44-PrivateKey'(Val, []).


'dec_pk-ml-dsa-44'('KeyValue',  Bytes,_) ->
   Bytes;
'dec_pk-ml-dsa-44'('Params',  Bytes,_) ->
   Bytes;
'dec_pk-ml-dsa-44'('PrivateKey', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_ML-DSA-44-PrivateKey'(Tlv, []).

tlv_format(Bytes) when is_binary(Bytes) ->
  {Tlv,_} = ber_decode_nif(Bytes),
  Tlv;
tlv_format(Bytes) ->
  Bytes.



%%================================
%%  pk-ml-dsa-65
%%================================
'enc_pk-ml-dsa-65'('KeyValue', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_pk-ml-dsa-65'('Params', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_pk-ml-dsa-65'('PrivateKey', Val, _RestPrimFieldName) ->
   'enc_ML-DSA-65-PrivateKey'(Val, []).


'dec_pk-ml-dsa-65'('KeyValue',  Bytes,_) ->
   Bytes;
'dec_pk-ml-dsa-65'('Params',  Bytes,_) ->
   Bytes;
'dec_pk-ml-dsa-65'('PrivateKey', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_ML-DSA-65-PrivateKey'(Tlv, []).




%%================================
%%  pk-ml-dsa-87
%%================================
'enc_pk-ml-dsa-87'('KeyValue', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_pk-ml-dsa-87'('Params', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_pk-ml-dsa-87'('PrivateKey', Val, _RestPrimFieldName) ->
   'enc_ML-DSA-87-PrivateKey'(Val, []).


'dec_pk-ml-dsa-87'('KeyValue',  Bytes,_) ->
   Bytes;
'dec_pk-ml-dsa-87'('Params',  Bytes,_) ->
   Bytes;
'dec_pk-ml-dsa-87'('PrivateKey', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_ML-DSA-87-PrivateKey'(Tlv, []).




%%================================
%%  sa-ml-dsa-44
%%================================
'enc_sa-ml-dsa-44'('Value', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_sa-ml-dsa-44'('Params', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_sa-ml-dsa-44'(smimeCaps,  Val, [H|T]) ->
   'enc_sa-ml-dsa-44_smimeCaps'(H, Val, T).


'dec_sa-ml-dsa-44'('Value',  Bytes,_) ->
   Bytes;
'dec_sa-ml-dsa-44'('Params',  Bytes,_) ->
   Bytes;
'dec_sa-ml-dsa-44'(smimeCaps, Bytes,[H|T]) ->
   'dec_sa-ml-dsa-44_smimeCaps'(H, Bytes, T).




%%================================
%%  sa-ml-dsa-65
%%================================
'enc_sa-ml-dsa-65'('Value', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_sa-ml-dsa-65'('Params', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_sa-ml-dsa-65'(smimeCaps,  Val, [H|T]) ->
   'enc_sa-ml-dsa-65_smimeCaps'(H, Val, T).


'dec_sa-ml-dsa-65'('Value',  Bytes,_) ->
   Bytes;
'dec_sa-ml-dsa-65'('Params',  Bytes,_) ->
   Bytes;
'dec_sa-ml-dsa-65'(smimeCaps, Bytes,[H|T]) ->
   'dec_sa-ml-dsa-65_smimeCaps'(H, Bytes, T).




%%================================
%%  sa-ml-dsa-87
%%================================
'enc_sa-ml-dsa-87'('Value', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_sa-ml-dsa-87'('Params', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_sa-ml-dsa-87'(smimeCaps,  Val, [H|T]) ->
   'enc_sa-ml-dsa-87_smimeCaps'(H, Val, T).


'dec_sa-ml-dsa-87'('Value',  Bytes,_) ->
   Bytes;
'dec_sa-ml-dsa-87'('Params',  Bytes,_) ->
   Bytes;
'dec_sa-ml-dsa-87'(smimeCaps, Bytes,[H|T]) ->
   'dec_sa-ml-dsa-87_smimeCaps'(H, Bytes, T).




%%================================
%%  sa-ml-dsa-87_smimeCaps
%%================================
'enc_sa-ml-dsa-87_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_sa-ml-dsa-87_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  sa-ml-dsa-65_smimeCaps
%%================================
'enc_sa-ml-dsa-65_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_sa-ml-dsa-65_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  sa-ml-dsa-44_smimeCaps
%%================================
'enc_sa-ml-dsa-44_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_sa-ml-dsa-44_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  PublicKeys
%%================================
getenc_PublicKeys(Id) when Id =:= {2,16,840,1,101,3,4,3,17} ->
    fun 'enc_pk-ml-dsa-44'/3;
getenc_PublicKeys(Id) when Id =:= {2,16,840,1,101,3,4,3,18} ->
    fun 'enc_pk-ml-dsa-65'/3;
getenc_PublicKeys(Id) when Id =:= {2,16,840,1,101,3,4,3,19} ->
    fun 'enc_pk-ml-dsa-87'/3;
getenc_PublicKeys(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_PublicKeys(Id) when Id =:= {2,16,840,1,101,3,4,3,17} ->
    fun 'dec_pk-ml-dsa-44'/3;
getdec_PublicKeys(Id) when Id =:= {2,16,840,1,101,3,4,3,18} ->
    fun 'dec_pk-ml-dsa-65'/3;
getdec_PublicKeys(Id) when Id =:= {2,16,840,1,101,3,4,3,19} ->
    fun 'dec_pk-ml-dsa-87'/3;
getdec_PublicKeys(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  SignatureAlgorithms
%%================================
getenc_SignatureAlgorithms(Id) when Id =:= {2,16,840,1,101,3,4,3,17} ->
    fun 'enc_sa-ml-dsa-44'/3;
getenc_SignatureAlgorithms(Id) when Id =:= {2,16,840,1,101,3,4,3,18} ->
    fun 'enc_sa-ml-dsa-65'/3;
getenc_SignatureAlgorithms(Id) when Id =:= {2,16,840,1,101,3,4,3,19} ->
    fun 'enc_sa-ml-dsa-87'/3;
getenc_SignatureAlgorithms(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_SignatureAlgorithms(Id) when Id =:= {2,16,840,1,101,3,4,3,17} ->
    fun 'dec_sa-ml-dsa-44'/3;
getdec_SignatureAlgorithms(Id) when Id =:= {2,16,840,1,101,3,4,3,18} ->
    fun 'dec_sa-ml-dsa-65'/3;
getdec_SignatureAlgorithms(Id) when Id =:= {2,16,840,1,101,3,4,3,19} ->
    fun 'dec_sa-ml-dsa-87'/3;
getdec_SignatureAlgorithms(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.



%%%
%%% Run-time functions.
%%%

'dialyzer-suppressions'(Arg) ->
    ok.

ber_decode_nif(B) ->
    asn1rt_nif:decode_ber_tlv(B).

ber_encode([Tlv]) ->
    ber_encode(Tlv);
ber_encode(Tlv) when is_binary(Tlv) ->
    Tlv;
ber_encode(Tlv) ->
    asn1rt_nif:encode_ber_tlv(Tlv).

collect_parts(TlvList) ->
    collect_parts(TlvList, []).

collect_parts([{_, L} | Rest], Acc) when is_list(L) ->
    collect_parts(Rest, [collect_parts(L) | Acc]);
collect_parts([{3, <<Unused,Bits/binary>>} | Rest], _Acc) ->
    collect_parts_bit(Rest, [Bits], Unused);
collect_parts([{_T, V} | Rest], Acc) ->
    collect_parts(Rest, [V | Acc]);
collect_parts([], Acc) ->
    list_to_binary(lists:reverse(Acc)).

collect_parts_bit([{3, <<Unused,Bits/binary>>} | Rest], Acc, Uacc) ->
    collect_parts_bit(Rest, [Bits | Acc], Unused + Uacc);
collect_parts_bit([], Acc, Uacc) ->
    list_to_binary([Uacc | lists:reverse(Acc)]).

decode_octet_string(Tlv, TagsIn) ->
    Bin = match_and_collect(Tlv, TagsIn),
    binary:copy(Bin).

encode_length(L) when L =< 127 ->
    {[L], 1};
encode_length(L) ->
    Oct = minimum_octets(L),
    Len = length(Oct),
    if
        Len =< 126 ->
            {[128 bor Len | Oct], Len + 1};
        true ->
            exit({error, {asn1, too_long_length_oct, Len}})
    end.

encode_restricted_string(OctetList, TagIn) when is_binary(OctetList) ->
    encode_tags(TagIn, OctetList, byte_size(OctetList));
encode_restricted_string(OctetList, TagIn) when is_list(OctetList) ->
    encode_tags(TagIn, OctetList, length(OctetList)).

encode_tags([Tag | Trest], BytesSoFar, LenSoFar) ->
    {Bytes2, L2} = encode_length(LenSoFar),
    encode_tags(Trest,
                [Tag, Bytes2 | BytesSoFar],
                LenSoFar + byte_size(Tag) + L2);
encode_tags([], BytesSoFar, LenSoFar) ->
    {BytesSoFar, LenSoFar}.

match_and_collect(Tlv, TagsIn) ->
    Val = match_tags(Tlv, TagsIn),
    case Val of
        [_ | _] = PartList ->
            collect_parts(PartList);
        Bin when is_binary(Bin) ->
            Bin
    end.

match_tags({T, V}, [T]) ->
    V;
match_tags({T, V}, [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, V}], [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, _V} | _] = Vlist, [T]) ->
    Vlist;
match_tags(Tlv, []) ->
    Tlv;
match_tags({Tag, _V} = Tlv, [T | _Tt]) ->
    exit({error, {asn1, {wrong_tag, {{expected, T}, {got, Tag, Tlv}}}}}).

minimum_octets(0, Acc) ->
    Acc;
minimum_octets(Val, Acc) ->
    minimum_octets(Val bsr 8, [Val band 255 | Acc]).

minimum_octets(Val) ->
    minimum_octets(Val, []).
