/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.URIUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XProcURIResolver
implements URIResolver,
EntityResolver {
    private URIResolver uriResolver = null;
    private EntityResolver entityResolver = null;
    private XProcRuntime runtime = null;
    private Hashtable<String, XdmNode> cache = new Hashtable();
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private static boolean useCache = true;

    public XProcURIResolver(XProcRuntime runtime) {
        this.runtime = runtime;
    }

    public void setUnderlyingURIResolver(URIResolver resolver) {
        this.uriResolver = resolver;
    }

    public void setUnderlyingEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    public void cache(XdmNode doc, URI baseURI) {
        XdmNode root = S9apiUtils.getDocumentElement(doc);
        URI docURI = baseURI.resolve(root.getBaseURI());
        if (useCache) {
            this.cache.put(docURI.toASCIIString(), doc);
        }
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        this.runtime.finest(null, null, "URIResolver(" + href + "," + base + ")");
        String uri = null;
        if (base == null) {
            try {
                URL url = new URL(href);
                uri = url.toURI().toASCIIString();
            }
            catch (MalformedURLException mue) {
                this.runtime.finest(null, null, "MalformedURLException on " + href);
            }
            catch (URISyntaxException use) {
                this.runtime.finest(null, null, "URISyntaxException on " + href);
            }
        } else {
            try {
                URI baseURI = new URI(base);
                uri = baseURI.resolve(href).toASCIIString();
            }
            catch (URISyntaxException use) {
                this.runtime.finest(null, null, "URISyntaxException resolving base and href: " + base + " : " + href);
            }
        }
        if (this.cache.containsKey(uri)) {
            this.runtime.finest(null, null, "Returning cached document.");
            return this.cache.get(uri).asSource();
        }
        if (this.uriResolver != null) {
            SAXSource ssource;
            XMLReader reader;
            URL absoluteURI = null;
            try {
                absoluteURI = base == null ? new URL(href) : new URL(new URL(base), href);
            }
            catch (MalformedURLException mue) {
                throw new XProcException(mue);
            }
            Source resolved = this.uriResolver.resolve(absoluteURI.toString(), base);
            if (resolved != null && resolved instanceof SAXSource && (reader = (ssource = (SAXSource)resolved).getXMLReader()) == null) {
                try {
                    reader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
                    reader.setEntityResolver(this);
                    ssource.setXMLReader(reader);
                }
                catch (SAXException se) {
                }
                catch (ParserConfigurationException pce) {
                    // empty catch block
                }
            }
            return resolved;
        }
        return null;
    }

    public XdmNode parse(String href, String base) {
        return this.parse(href, base, false);
    }

    public XdmNode parse(String href, String base, boolean dtdValidate) {
        Source source = null;
        href = URIUtils.encode(href);
        this.runtime.finest(null, null, "Attempting to parse: " + href + " (" + base + ")");
        try {
            source = this.resolve(href, base);
        }
        catch (TransformerException te) {
            throw new XProcException(XProcConstants.dynamicError(9), (Throwable)te);
        }
        if (source == null) {
            try {
                URI baseURI = new URI(base);
                source = new SAXSource(new InputSource(baseURI.resolve(href).toASCIIString()));
                XMLReader reader = ((SAXSource)source).getXMLReader();
                if (reader == null) {
                    try {
                        reader = XMLReaderFactory.createXMLReader();
                        ((SAXSource)source).setXMLReader(reader);
                        reader.setEntityResolver(this);
                    }
                    catch (SAXException se) {}
                }
            }
            catch (URISyntaxException use) {
                throw new XProcException(use);
            }
        }
        DocumentBuilder builder = this.runtime.getProcessor().newDocumentBuilder();
        builder.setDTDValidation(dtdValidate);
        builder.setLineNumbering(true);
        try {
            return builder.build(source);
        }
        catch (SaxonApiException sae) {
            String msg = sae.getMessage();
            if (msg.contains("validation")) {
                throw XProcException.stepError(27, (Exception)((Object)sae));
            }
            if (msg.contains("HTTP response code: 403 ")) {
                throw XProcException.dynamicError(21);
            }
            throw XProcException.dynamicError(11, (Exception)((Object)sae));
        }
    }

    public XdmNode parse(InputSource isource) {
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setEntityResolver(this);
            SAXSource source = new SAXSource(reader, isource);
            DocumentBuilder builder = this.runtime.getProcessor().newDocumentBuilder();
            builder.setLineNumbering(true);
            builder.setDTDValidation(false);
            return builder.build((Source)source);
        }
        catch (SaxonApiException sae) {
            String msg = sae.getMessage();
            if (msg.contains("validation")) {
                throw XProcException.stepError(27, (Exception)((Object)sae));
            }
            if (msg.contains("HTTP response code: 403 ")) {
                throw XProcException.dynamicError(21);
            }
            throw XProcException.dynamicError(11, (Exception)((Object)sae));
        }
        catch (SAXException e) {
            throw new XProcException(e);
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        this.runtime.finest(null, null, "ResolveEntity(" + publicId + "," + systemId + ")");
        try {
            URI baseURI = new URI(systemId);
            String uri = baseURI.toASCIIString();
            if (this.cache.containsKey(uri)) {
                this.runtime.finest(null, null, "Returning cached document.");
                return S9apiUtils.xdmToInputSource(this.runtime, this.cache.get(uri));
            }
        }
        catch (URISyntaxException use) {
            this.runtime.finest(null, null, "URISyntaxException resolving entityResolver systemId: " + systemId);
        }
        catch (SaxonApiException sae) {
            throw new XProcException(sae);
        }
        if (this.entityResolver != null) {
            InputSource r = this.entityResolver.resolveEntity(publicId, systemId);
            return r;
        }
        return null;
    }
}

