/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.sort;

import com.icl.saxon.Context;
import com.icl.saxon.Loader;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.StaticContext;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.Name;
import com.icl.saxon.sort.Compare_en;
import com.icl.saxon.sort.Comparer;
import com.icl.saxon.sort.DoubleComparer;
import com.icl.saxon.sort.StringComparer;
import com.icl.saxon.sort.TextComparer;
import javax.xml.transform.TransformerException;

public class SortKeyDefinition {
    private Expression sortKey;
    private Expression order;
    private Expression dataType;
    private Expression caseOrder;
    private Expression language;
    private StaticContext staticContext;
    private Comparer comparer = null;

    public void setSortKey(Expression expression) {
        this.sortKey = expression;
    }

    public void setOrder(Expression expression) {
        this.order = expression;
    }

    public void setDataType(Expression expression) {
        this.dataType = expression;
    }

    public void setCaseOrder(Expression expression) {
        this.caseOrder = expression;
    }

    public void setLanguage(Expression expression) {
        this.language = expression;
    }

    public void setStaticContext(StaticContext staticContext) {
        this.staticContext = staticContext;
    }

    public Expression getSortKey() {
        return this.sortKey;
    }

    public Expression getOrder() {
        return this.order == null ? new StringValue("ascending") : this.order;
    }

    public Expression getDataType() {
        return this.dataType == null ? new StringValue("text") : this.dataType;
    }

    public Expression getCaseOrder() {
        return this.caseOrder == null ? new StringValue("#default") : this.caseOrder;
    }

    public Expression getLanguage() {
        return this.language == null ? new StringValue("en") : this.language;
    }

    public void bindComparer() throws XPathException {
        if (this.dataType instanceof StringValue && this.order instanceof StringValue && this.caseOrder instanceof StringValue && this.language instanceof StringValue) {
            this.comparer = this.makeComparer(null);
        }
    }

    public Comparer getComparer(Context context) throws XPathException {
        if (this.comparer == null) {
            return this.makeComparer(context);
        }
        return this.comparer;
    }

    private Comparer makeComparer(Context context) throws XPathException {
        Comparer comparer;
        int n;
        String string;
        String string2;
        boolean bl;
        String string3 = this.order == null ? "ascending" : this.order.evaluateAsString(context);
        if (string3.equals("ascending")) {
            bl = true;
        } else if (string3.equals("descending")) {
            bl = false;
        } else {
            throw new XPathException("order must be ascending or descending");
        }
        String string4 = this.dataType == null ? "text" : this.dataType.evaluateAsString(context);
        if (string4.equals("text")) {
            string2 = null;
            string = null;
        } else if (string4.equals("number")) {
            string2 = null;
            string = null;
        } else {
            String string5 = Name.getPrefix(string4);
            if (string5.equals("")) {
                throw new XPathException("data-type must be text, number, or a prefixed name");
            }
            string2 = this.staticContext.getURIForPrefix(string5);
            string = Name.getLocalName(string4);
        }
        String string6 = this.caseOrder == null ? "#default" : this.caseOrder.evaluateAsString(context);
        if (string6.equals("#default")) {
            n = 0;
        } else if (string6.equals("lower-first")) {
            n = 1;
        } else if (string6.equals("upper-first")) {
            n = 2;
        } else {
            throw new XPathException("case-order must be lower-first or upper-first");
        }
        if (string4.equals("text")) {
            if (this.language == null) {
                comparer = new StringComparer();
            } else {
                String string7 = this.language.evaluateAsString(context);
                String string8 = "com.icl.saxon.sort.Compare_";
                int n2 = 0;
                while (n2 < string7.length()) {
                    if (Character.isLetter(string7.charAt(n2))) {
                        string8 = string8 + string7.charAt(n2);
                    }
                    ++n2;
                }
                try {
                    comparer = SortKeyDefinition.loadComparer(string8);
                }
                catch (Exception exception) {
                    comparer = new Compare_en();
                }
            }
        } else if (string4.equals("number")) {
            comparer = new DoubleComparer();
        } else {
            try {
                comparer = SortKeyDefinition.loadComparer(string);
            }
            catch (Exception exception) {
                System.err.println("Warning: no comparer " + string + " found; using default");
                comparer = new StringComparer();
            }
        }
        comparer = comparer.setDataType(string2, string);
        comparer = comparer.setOrder(bl);
        if (comparer instanceof TextComparer) {
            comparer = ((TextComparer)comparer).setCaseOrder(n);
        }
        return comparer;
    }

    private static TextComparer loadComparer(String string) throws XPathException {
        try {
            return (TextComparer)Loader.getInstance(string);
        }
        catch (ClassCastException classCastException) {
            throw new XPathException("Failed to load TextComparer  " + string + ": it does not implement the TextComparer interface");
        }
        catch (TransformerException transformerException) {
            if (transformerException instanceof XPathException) {
                throw (XPathException)transformerException;
            }
            throw new XPathException(transformerException);
        }
    }
}

