/*
 * wxCHTDecoder
 * Copyright (C) 2004,2008 emuWorks
 * http://games.technoplaza.net/
 *
 * This file is part of wxCHTDecoder.
 *
 * wxCHTDecoder is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * wxCHTDecoder is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with wxCHTDecoder; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

// $Id: chtcode.hh,v 1.4 2008/12/15 03:57:04 jdratlif Exp $

#ifndef WXCHTDECODER_CHTCODE_HH_
#define WXCHTDECODER_CHTCODE_HH_

#include <wx/string.h>

namespace wxCHTDecoder {
    class CHTCode {
    public:
        CHTCode(wxString &, int, int, bool);
        CHTCode(const CHTCode &);
        ~CHTCode();
    
        static CHTCode parseCHTData(const char *data);
    
        const wxString &getName() const { return *name; }
        
        void setName(const wxString &name) {
            if (this->name) {
                delete this->name;
            }
        
            this->name = new wxString(name);
        }
    
        int getAddress() const { return address; }
        
        void setAddress(int address) {
            if ((address & 0xFF000000) == 0) { 
                this->address = address;
            }
        }
    
        int getValue() const { return value; }
    
        void setValue(int value) {
            if ((value & 0xFFFFFF00) == 0) {
                this->value = value;
            }
        }
    
        bool isActive() const { return active; }
        void setActive(bool active) { this->active = active; }
        
        wxString toString();
    private:
        wxString *name;
        int address, value;
        bool active;
    };
}

#endif

