/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ar extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "العربية";
        final String metaValue_pi = "البالية";
        final String metaValue_bn = "البنغالية";
        final String metaValue_chr = "الشيروكي";
        final String metaValue_cop = "القبطية";
        final String metaValue_ka = "الجورجية";
        final String metaValue_got = "القوطية";
        final String metaValue_el = "اليونانية";
        final String metaValue_he = "العبرية";
        final String metaValue_jv = "الجاوية";
        final String metaValue_ja = "اليابانية";
        final String metaValue_km = "الخميرية";
        final String metaValue_kn = "الكانادا";
        final String metaValue_ko = "الكورية";
        final String metaValue_la = "اللاتينية";
        final String metaValue_nqo = "أنكو";
        final String metaValue_phn = "الفينيقية";
        final String metaValue_su = "السوندانية";
        final String metaValue_syr = "السريانية";
        final String metaValue_ta = "التاميلية";
        final String metaValue_th = "التايلاندية";
        final String metaValue_bo = "التبتية";
        final String metaValue_vai = "الفاي";
        final String metaValue_peo = "الفارسية القديمة";
        final Object[][] data = new Object[][] {
            { "001", "العالم" },
            { "002", "أفريقيا" },
            { "003", "أمريكا الشمالية" },
            { "005", "أمريكا الجنوبية" },
            { "009", "أوقيانوسيا" },
            { "011", "غرب أفريقيا" },
            { "013", "أمريكا الوسطى" },
            { "014", "شرق أفريقيا" },
            { "015", "شمال أفريقيا" },
            { "017", "وسط أفريقيا" },
            { "018", "أفريقيا الجنوبية" },
            { "019", "الأمريكتان" },
            { "021", "شمال أمريكا" },
            { "029", "الكاريبي" },
            { "030", "شرق آسيا" },
            { "034", "جنوب آسيا" },
            { "035", "جنوب شرق آسيا" },
            { "039", "جنوب أوروبا" },
            { "053", "أسترالاسيا" },
            { "054", "ميلانيزيا" },
            { "057", "الجزر الميكرونيزية" },
            { "061", "بولينيزيا" },
            { "142", "آسيا" },
            { "143", "وسط آسيا" },
            { "145", "غرب آسيا" },
            { "150", "أوروبا" },
            { "151", "شرق أوروبا" },
            { "154", "شمال أوروبا" },
            { "155", "غرب أوروبا" },
            { "202", "أفريقيا جنوب الصحراء الكبرى" },
            { "419", "أمريكا اللاتينية" },
            { "AC", "جزيرة أسينشيون" },
            { "AD", "أندورا" },
            { "AE", "الإمارات العربية المتحدة" },
            { "AF", "أفغانستان" },
            { "AG", "أنتيغوا وبربودا" },
            { "AI", "أنغويلا" },
            { "AL", "ألبانيا" },
            { "AM", "أرمينيا" },
            { "AO", "أنغولا" },
            { "AQ", "أنتاركتيكا" },
            { "AR", "الأرجنتين" },
            { "AS", "ساموا الأمريكية" },
            { "AT", "النمسا" },
            { "AU", "أستراليا" },
            { "AW", "أروبا" },
            { "AX", "جزر آلاند" },
            { "AZ", "أذربيجان" },
            { "BA", "البوسنة والهرسك" },
            { "BB", "بربادوس" },
            { "BD", "بنغلاديش" },
            { "BE", "بلجيكا" },
            { "BF", "بوركينا فاسو" },
            { "BG", "بلغاريا" },
            { "BH", "البحرين" },
            { "BI", "بوروندي" },
            { "BJ", "بنين" },
            { "BL", "سان بارتليمي" },
            { "BM", "برمودا" },
            { "BN", "بروناي" },
            { "BO", "بوليفيا" },
            { "BQ", "هولندا الكاريبية" },
            { "BR", "البرازيل" },
            { "BS", "جزر البهاما" },
            { "BT", "بوتان" },
            { "BV", "جزيرة بوفيه" },
            { "BW", "بوتسوانا" },
            { "BY", "بيلاروس" },
            { "BZ", "بليز" },
            { "CA", "كندا" },
            { "CC", "جزر كوكوس (كيلينغ)" },
            { "CD", "الكونغو - كينشاسا" },
            { "CF", "جمهورية أفريقيا الوسطى" },
            { "CG", "الكونغو - برازافيل" },
            { "CH", "سويسرا" },
            { "CI", "ساحل العاج" },
            { "CK", "جزر كوك" },
            { "CL", "تشيلي" },
            { "CM", "الكاميرون" },
            { "CN", "الصين" },
            { "CO", "كولومبيا" },
            { "CP", "جزيرة كليبيرتون" },
            { "CQ", "سارك" },
            { "CR", "كوستاريكا" },
            { "CU", "كوبا" },
            { "CV", "الرأس الأخضر" },
            { "CW", "كوراساو" },
            { "CX", "جزيرة كريسماس" },
            { "CY", "قبرص" },
            { "CZ", "التشيك" },
            { "DE", "ألمانيا" },
            { "DG", "دييغو غارسيا" },
            { "DJ", "جيبوتي" },
            { "DK", "الدانمرك" },
            { "DM", "دومينيكا" },
            { "DO", "جمهورية الدومينيكان" },
            { "DZ", "الجزائر" },
            { "EA", "سيوتا وميليلا" },
            { "EC", "الإكوادور" },
            { "EE", "إستونيا" },
            { "EG", "مصر" },
            { "EH", "الصحراء الغربية" },
            { "ER", "إريتريا" },
            { "ES", "إسبانيا" },
            { "ET", "إثيوبيا" },
            { "EU", "الاتحاد الأوروبي" },
            { "EZ", "منطقة اليورو" },
            { "FI", "فنلندا" },
            { "FJ", "فيجي" },
            { "FK", "جزر فوكلاند" },
            { "FM", "ميكرونيزيا" },
            { "FO", "جزر فارو" },
            { "FR", "فرنسا" },
            { "GA", "الغابون" },
            { "GB", "المملكة المتحدة" },
            { "GD", "غرينادا" },
            { "GE", "جورجيا" },
            { "GF", "غويانا الفرنسية" },
            { "GG", "غيرنزي" },
            { "GH", "غانا" },
            { "GI", "جبل طارق" },
            { "GL", "غرينلاند" },
            { "GM", "غامبيا" },
            { "GN", "غينيا" },
            { "GP", "غوادلوب" },
            { "GQ", "غينيا الاستوائية" },
            { "GR", "اليونان" },
            { "GS", "جورجيا الجنوبية وجزر ساندويتش الجنوبية" },
            { "GT", "غواتيمالا" },
            { "GU", "غوام" },
            { "GW", "غينيا بيساو" },
            { "GY", "غيانا" },
            { "HK", "هونغ كونغ الصينية (منطقة إدارية خاصة)" },
            { "HM", "جزيرة هيرد وجزر ماكدونالد" },
            { "HN", "هندوراس" },
            { "HR", "كرواتيا" },
            { "HT", "هايتي" },
            { "HU", "هنغاريا" },
            { "IC", "جزر الكناري" },
            { "ID", "إندونيسيا" },
            { "IE", "أيرلندا" },
            { "IL", "إسرائيل" },
            { "IM", "جزيرة مان" },
            { "IN", "الهند" },
            { "IO", "الإقليم البريطاني في المحيط الهندي" },
            { "IQ", "العراق" },
            { "IR", "إيران" },
            { "IS", "آيسلندا" },
            { "IT", "إيطاليا" },
            { "JE", "جيرسي" },
            { "JM", "جامايكا" },
            { "JO", "الأردن" },
            { "JP", "اليابان" },
            { "KE", "كينيا" },
            { "KG", "قيرغيزستان" },
            { "KH", "كمبوديا" },
            { "KI", "كيريباتي" },
            { "KM", "جزر القمر" },
            { "KN", "سانت كيتس ونيفيس" },
            { "KP", "كوريا الشمالية" },
            { "KR", "كوريا الجنوبية" },
            { "KW", "الكويت" },
            { "KY", "جزر كايمان" },
            { "KZ", "كازاخستان" },
            { "LA", "لاوس" },
            { "LB", "لبنان" },
            { "LC", "سانت لوسيا" },
            { "LI", "ليختنشتاين" },
            { "LK", "سريلانكا" },
            { "LR", "ليبيريا" },
            { "LS", "ليسوتو" },
            { "LT", "ليتوانيا" },
            { "LU", "لوكسمبورغ" },
            { "LV", "لاتفيا" },
            { "LY", "ليبيا" },
            { "MA", "المغرب" },
            { "MC", "موناكو" },
            { "MD", "مولدوفا" },
            { "ME", "الجبل الأسود" },
            { "MF", "سان مارتن" },
            { "MG", "مدغشقر" },
            { "MH", "جزر مارشال" },
            { "MK", "مقدونيا الشمالية" },
            { "ML", "مالي" },
            { "MM", "ميانمار (بورما)" },
            { "MN", "منغوليا" },
            { "MO", "منطقة ماكاو الإدارية الخاصة" },
            { "MP", "جزر ماريانا الشمالية" },
            { "MQ", "جزر المارتينيك" },
            { "MR", "موريتانيا" },
            { "MS", "مونتسرات" },
            { "MT", "مالطا" },
            { "MU", "موريشيوس" },
            { "MV", "جزر المالديف" },
            { "MW", "ملاوي" },
            { "MX", "المكسيك" },
            { "MY", "ماليزيا" },
            { "MZ", "موزمبيق" },
            { "NA", "ناميبيا" },
            { "NC", "كاليدونيا الجديدة" },
            { "NE", "النيجر" },
            { "NF", "جزيرة نورفولك" },
            { "NG", "نيجيريا" },
            { "NI", "نيكاراغوا" },
            { "NL", "هولندا" },
            { "NO", "النرويج" },
            { "NP", "نيبال" },
            { "NR", "ناورو" },
            { "NU", "نيوي" },
            { "NZ", "نيوزيلندا" },
            { "OM", "عُمان" },
            { "PA", "بنما" },
            { "PE", "بيرو" },
            { "PF", "بولينيزيا الفرنسية" },
            { "PG", "بابوا غينيا الجديدة" },
            { "PH", "الفلبين" },
            { "PK", "باكستان" },
            { "PL", "بولندا" },
            { "PM", "سان بيير ومكويلون" },
            { "PN", "جزر بيتكيرن" },
            { "PR", "بورتوريكو" },
            { "PS", "الأراضي الفلسطينية" },
            { "PT", "البرتغال" },
            { "PW", "بالاو" },
            { "PY", "باراغواي" },
            { "QA", "قطر" },
            { "QO", "أوقيانوسيا النائية" },
            { "RE", "روينيون" },
            { "RO", "رومانيا" },
            { "RS", "صربيا" },
            { "RU", "روسيا" },
            { "RW", "رواندا" },
            { "SA", "المملكة العربية السعودية" },
            { "SB", "جزر سليمان" },
            { "SC", "سيشل" },
            { "SD", "السودان" },
            { "SE", "السويد" },
            { "SG", "سنغافورة" },
            { "SH", "سانت هيلينا" },
            { "SI", "سلوفينيا" },
            { "SJ", "سفالبارد وجان ماين" },
            { "SK", "سلوفاكيا" },
            { "SL", "سيراليون" },
            { "SM", "سان مارينو" },
            { "SN", "السنغال" },
            { "SO", "الصومال" },
            { "SR", "سورينام" },
            { "SS", "جنوب السودان" },
            { "ST", "ساو تومي وبرينسيبي" },
            { "SV", "السلفادور" },
            { "SX", "سانت مارتن" },
            { "SY", "سوريا" },
            { "SZ", "إسواتيني" },
            { "TA", "تريستان دا كونا" },
            { "TC", "جزر توركس وكايكوس" },
            { "TD", "تشاد" },
            { "TF", "الأقاليم الجنوبية الفرنسية" },
            { "TG", "توغو" },
            { "TH", "تايلاند" },
            { "TJ", "طاجيكستان" },
            { "TK", "توكيلاو" },
            { "TL", "تيمور - ليشتي" },
            { "TM", "تركمانستان" },
            { "TN", "تونس" },
            { "TO", "تونغا" },
            { "TR", "تركيا" },
            { "TT", "ترينيداد وتوباغو" },
            { "TV", "توفالو" },
            { "TW", "تايوان" },
            { "TZ", "تنزانيا" },
            { "UA", "أوكرانيا" },
            { "UG", "أوغندا" },
            { "UM", "جزر الولايات المتحدة النائية" },
            { "UN", "الأمم المتحدة" },
            { "US", "الولايات المتحدة" },
            { "UY", "أورغواي" },
            { "UZ", "أوزبكستان" },
            { "VA", "الفاتيكان" },
            { "VC", "سانت فنسنت وجزر غرينادين" },
            { "VE", "فنزويلا" },
            { "VG", "جزر فيرجن البريطانية" },
            { "VI", "جزر فيرجن الأمريكية" },
            { "VN", "فيتنام" },
            { "VU", "فانواتو" },
            { "WF", "جزر والس وفوتونا" },
            { "WS", "ساموا" },
            { "XA", "لكنات تجريبية غير أصلية" },
            { "XB", "لكنات تجريبية ثنائية الاتجاه" },
            { "XK", "كوسوفو" },
            { "YE", "اليمن" },
            { "YT", "مايوت" },
            { "ZA", "جنوب أفريقيا" },
            { "ZM", "زامبيا" },
            { "ZW", "زيمبابوي" },
            { "ZZ", "منطقة غير معروفة" },
            { "aa", "الأفارية" },
            { "ab", "الأبخازية" },
            { "ae", "الأفستية" },
            { "af", "الأفريقانية" },
            { "ak", "الأكانية" },
            { "am", "الأمهرية" },
            { "an", "الأراغونية" },
            { "ar", metaValue_ar },
            { "as", "الأسامية" },
            { "av", "الأوارية" },
            { "ay", "الأيمارا" },
            { "az", "الأذربيجانية" },
            { "ba", "الباشكيرية" },
            { "be", "البيلاروسية" },
            { "bg", "البلغارية" },
            { "bi", "البيسلامية" },
            { "bm", "البامبارا" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "البريتونية" },
            { "bs", "البوسنية" },
            { "ca", "الكتالانية" },
            { "ce", "الشيشانية" },
            { "ch", "التشامورو" },
            { "co", "الكورسيكية" },
            { "cr", "الكرى" },
            { "cs", "التشيكية" },
            { "cu", "سلافية كنسية" },
            { "cv", "التشوفاشي" },
            { "cy", "الويلزية" },
            { "da", "الدانمركية" },
            { "de", "الألمانية" },
            { "dv", "المالديفية" },
            { "dz", "دزونكا" },
            { "ee", "الإيوي" },
            { "el", metaValue_el },
            { "en", "الإنجليزية" },
            { "eo", "الإسبرانتو" },
            { "es", "الإسبانية" },
            { "et", "الإستونية" },
            { "eu", "الباسكية" },
            { "fa", "الفارسية" },
            { "ff", "الفولانية" },
            { "fi", "الفنلندية" },
            { "fj", "الفيجية" },
            { "fo", "الفاروية" },
            { "fr", "الفرنسية" },
            { "fy", "الفريزيان" },
            { "ga", "الأيرلندية" },
            { "gd", "الغيلية الأسكتلندية" },
            { "gl", "الجاليكية" },
            { "gn", "الغوارانية" },
            { "gu", "الغوجاراتية" },
            { "gv", "المنكية" },
            { "ha", "الهوسا" },
            { "he", metaValue_he },
            { "hi", "الهندية" },
            { "ho", "الهيري موتو" },
            { "hr", "الكرواتية" },
            { "ht", "الكريولية الهايتية" },
            { "hu", "الهنغارية" },
            { "hy", "الأرمنية" },
            { "hz", "الهيريرو" },
            { "ia", "اللّغة الوسيطة" },
            { "id", "الإندونيسية" },
            { "ie", "الإنترلينج" },
            { "ig", "الإيجبو" },
            { "ii", "السيتشيون يي" },
            { "ik", "الإينبياك" },
            { "io", "الإيدو" },
            { "is", "الأيسلندية" },
            { "it", "الإيطالية" },
            { "iu", "الإينكتيتت" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "الكونغو" },
            { "ki", "الكيكيو" },
            { "kj", "كوانياما" },
            { "kk", "الكازاخستانية" },
            { "kl", "الكالاليست" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "الكانوري" },
            { "ks", "الكشميرية" },
            { "ku", "الكرمانجية" },
            { "kv", "الكومي" },
            { "kw", "الكورنية" },
            { "ky", "القيرغيزية" },
            { "la", metaValue_la },
            { "lb", "اللكسمبورغية" },
            { "lg", "الغاندا" },
            { "li", "الليمبورغية" },
            { "ln", "اللينجالا" },
            { "lo", "اللاوية" },
            { "lt", "الليتوانية" },
            { "lu", "اللوبا كاتانغا" },
            { "lv", "اللاتفية" },
            { "mg", "الملغاشي" },
            { "mh", "المارشالية" },
            { "mi", "الماورية" },
            { "mk", "المقدونية" },
            { "ml", "المالايالامية" },
            { "mn", "المنغولية" },
            { "mr", "الماراثية" },
            { "ms", "الماليزية" },
            { "mt", "المالطية" },
            { "my", "البورمية" },
            { "na", "النورو" },
            { "nb", "النرويجية بوكمال" },
            { "nd", "النديبيل الشمالية" },
            { "ne", "النيبالية" },
            { "ng", "الندونجا" },
            { "nl", "الهولندية" },
            { "nn", "النرويجية نينورسك" },
            { "no", "النرويجية" },
            { "nr", "النديبيل الجنوبي" },
            { "nv", "النافاجو" },
            { "ny", "النيانجا" },
            { "oc", "الأوكسيتانية" },
            { "oj", "الأوجيبوا" },
            { "om", "الأورومية" },
            { "or", "الأورية" },
            { "os", "الأوسيتيك" },
            { "pa", "البنجابية" },
            { "pi", metaValue_pi },
            { "pl", "البولندية" },
            { "ps", "البشتو" },
            { "pt", "البرتغالية" },
            { "qu", "كيشوا" },
            { "rm", "الرومانشية" },
            { "rn", "الرندي" },
            { "ro", "الرومانية" },
            { "ru", "الروسية" },
            { "rw", "الكينيارواندا" },
            { "sa", "السنسكريتية" },
            { "sc", "السردينية" },
            { "sd", "السندية" },
            { "se", "سامي الشمالية" },
            { "sg", "السانجو" },
            { "sh", "صربية-كرواتية" },
            { "si", "السنهالية" },
            { "sk", "السلوفاكية" },
            { "sl", "السلوفانية" },
            { "sm", "الساموائية" },
            { "sn", "الشونا" },
            { "so", "الصومالية" },
            { "sq", "الألبانية" },
            { "sr", "الصربية" },
            { "ss", "السواتي" },
            { "st", "السوتو الجنوبية" },
            { "su", metaValue_su },
            { "sv", "السويدية" },
            { "sw", "السواحلية" },
            { "ta", metaValue_ta },
            { "te", "التيلوغوية" },
            { "tg", "الطاجيكية" },
            { "th", metaValue_th },
            { "ti", "التغرينية" },
            { "tk", "التركمانية" },
            { "tl", "التاغالوغية" },
            { "tn", "التسوانية" },
            { "to", "التونغية" },
            { "tr", "التركية" },
            { "ts", "السونجا" },
            { "tt", "التترية" },
            { "tw", "التوي" },
            { "ty", "التاهيتية" },
            { "ug", "الأويغورية" },
            { "uk", "الأوكرانية" },
            { "ur", "الأوردية" },
            { "uz", "الأوزبكية" },
            { "ve", "الفيندا" },
            { "vi", "الفيتنامية" },
            { "vo", "لغة الفولابوك" },
            { "wa", "الولونية" },
            { "wo", "الولوفية" },
            { "xh", "الخوسا" },
            { "yi", "اليديشية" },
            { "yo", "اليوروبا" },
            { "za", "الزهيونج" },
            { "zh", "الصينية" },
            { "zu", "الزولو" },
            { "ace", "الأتشينيزية" },
            { "ach", "الأكولية" },
            { "ada", "الأدانجمية" },
            { "ady", "الأديغة" },
            { "afh", "الأفريهيلية" },
            { "agq", "الأغم" },
            { "ain", "الآينوية" },
            { "akk", "الأكادية" },
            { "ale", "الأليوتية" },
            { "alt", "الألطائية الجنوبية" },
            { "ang", "الإنجليزية القديمة" },
            { "ann", "أوبلو" },
            { "anp", "الأنجيكا" },
            { "arc", "الآرامية" },
            { "arn", "المابودونغونية" },
            { "arp", "الأراباهو" },
            { "ars", "اللهجة النجدية" },
            { "arw", "الأراواكية" },
            { "asa", "الآسو" },
            { "ast", "الأسترية" },
            { "atj", "الأتيكاميكو" },
            { "awa", "الأوادية" },
            { "bal", "البلوشية" },
            { "ban", "البالينية" },
            { "bas", "الباسا" },
            { "bax", "بامن" },
            { "bbj", "لغة الغومالا" },
            { "bej", "البيجا" },
            { "bem", "البيمبا" },
            { "bez", "بينا" },
            { "bfd", "لغة البافوت" },
            { "bgc", "الهارينفية" },
            { "bgn", "البلوشية الغربية" },
            { "bho", "البهوجبورية" },
            { "bik", "البيكولية" },
            { "bin", "البينية" },
            { "bkm", "لغة الكوم" },
            { "bla", "السيكسيكية" },
            { "blo", "الآنية" },
            { "bra", "البراجية" },
            { "brx", "البودو" },
            { "bss", "أكوس" },
            { "bua", "البرياتية" },
            { "bug", "البجينيزية" },
            { "bum", "لغة البولو" },
            { "byn", "البلينية" },
            { "byv", "لغة الميدومبا" },
            { "cad", "الكادو" },
            { "car", "الكاريبية" },
            { "cay", "الكايوجية" },
            { "cch", "الأتسام" },
            { "ccp", "تشاكما" },
            { "ceb", "السيبيوانية" },
            { "cgg", "تشيغا" },
            { "chb", "التشيبشا" },
            { "chg", "التشاجاتاي" },
            { "chk", "التشكيزية" },
            { "chm", "الماري" },
            { "chn", "الشينوك جارجون" },
            { "cho", "الشوكتو" },
            { "chp", "الشيباوايان" },
            { "chr", metaValue_chr },
            { "chy", "الشايان" },
            { "ckb", "السورانية الكردية" },
            { "clc", "تسيلكوتين" },
            { "cop", metaValue_cop },
            { "crg", "الميتشيف" },
            { "crh", "لغة تتار القرم" },
            { "crj", "الكري الجنوب شرقية" },
            { "crk", "البلينز-كري" },
            { "crl", "الكري شمال الشرقية" },
            { "crm", "الموس-كري" },
            { "crr", "الألغونكوية كارولينا" },
            { "crs", "الفرنسية الكريولية السيشيلية" },
            { "csb", "الكاشبايان" },
            { "csw", "السوامبي-كري" },
            { "dak", "الداكوتا" },
            { "dar", "الدارجوا" },
            { "dav", "تيتا" },
            { "del", "الديلوير" },
            { "den", "السلافية" },
            { "dgr", "الدوجريب" },
            { "din", "الدنكا" },
            { "dje", "الزارمية" },
            { "doi", "الدوجرية" },
            { "dsb", "صوربيا السفلى" },
            { "dua", "الديولا" },
            { "dum", "الهولندية الوسطى" },
            { "dyo", "جولا فونيا" },
            { "dyu", "الدايلا" },
            { "dzg", "القرعانية" },
            { "ebu", "إمبو" },
            { "efi", "الإفيك" },
            { "egy", "المصرية القديمة" },
            { "eka", "الإكاجك" },
            { "elx", "الإمايت" },
            { "enm", "الإنجليزية الوسطى" },
            { "ewo", "الإيوندو" },
            { "fan", "الفانج" },
            { "fat", "الفانتي" },
            { "fil", "الفلبينية" },
            { "fon", "الفون" },
            { "frc", "الفرنسية الكاجونية" },
            { "frm", "الفرنسية الوسطى" },
            { "fro", "الفرنسية القديمة" },
            { "frr", "الفريزينية الشمالية" },
            { "frs", "الفريزينية الشرقية" },
            { "fur", "الفريلايان" },
            { "gaa", "الجا" },
            { "gag", "الغاغوز" },
            { "gan", "الغان الصينية" },
            { "gay", "الجايو" },
            { "gba", "الجبيا" },
            { "gez", "الجعزية" },
            { "gil", "لغة أهل جبل طارق" },
            { "gmh", "الألمانية العليا الوسطى" },
            { "goh", "الألمانية العليا القديمة" },
            { "gon", "الجندي" },
            { "gor", "الجورونتالو" },
            { "got", metaValue_got },
            { "grb", "الجريبو" },
            { "grc", "اليونانية القديمة" },
            { "gsw", "الألمانية السويسرية" },
            { "guz", "الغيزية" },
            { "gwi", "غوتشن" },
            { "hai", "الهيدا" },
            { "hak", "الهاكا الصينية" },
            { "haw", "لغة هاواي" },
            { "hax", "هايدا الجنوبية" },
            { "hil", "الهيليجينون" },
            { "hit", "الحثية" },
            { "hmn", "الهمونجية" },
            { "hsb", "الصوربية العليا" },
            { "hsn", "شيانغ الصينية" },
            { "hup", "الهبا" },
            { "hur", "الهالكوميليم" },
            { "iba", "الإيبان" },
            { "ibb", "الإيبيبيو" },
            { "ikt", "الإنكتيتوتية الكندية الغربية" },
            { "ilo", "الإيلوكو" },
            { "inh", "الإنجوشية" },
            { "jbo", "اللوجبان" },
            { "jgo", "نغومبا" },
            { "jmc", "الماتشامية" },
            { "jpr", "الفارسية اليهودية" },
            { "jrb", "العربية اليهودية" },
            { "kaa", "الكارا-كالباك" },
            { "kab", "القبيلية" },
            { "kac", "الكاتشين" },
            { "kaj", "الجو" },
            { "kam", "الكامبا" },
            { "kaw", "الكوي" },
            { "kbd", "الكاباردايان" },
            { "kbl", "كانمبو" },
            { "kcg", "التايابية" },
            { "kde", "ماكونده" },
            { "kea", "كابوفيرديانو" },
            { "kfo", "الكورو" },
            { "kgp", "الكاينغانغ" },
            { "kha", "الكازية" },
            { "kho", "الخوتانيز" },
            { "khq", "كويرا تشيني" },
            { "kkj", "لغة الكاكو" },
            { "kln", "كالينجين" },
            { "kmb", "الكيمبندو" },
            { "koi", "كومي-بيرماياك" },
            { "kok", "الكونكانية" },
            { "kos", "الكوسراين" },
            { "kpe", "الكبيل" },
            { "krc", "الكاراتشاي-بالكار" },
            { "krl", "الكاريلية" },
            { "kru", "الكوروخ" },
            { "ksb", "شامبالا" },
            { "ksf", "لغة البافيا" },
            { "ksh", "لغة الكولونيان" },
            { "kum", "القموقية" },
            { "kut", "الكتيناي" },
            { "kwk", "الكواكوالا" },
            { "kxv", "الكوفية" },
            { "lad", "اللادينو" },
            { "lag", "لانجي" },
            { "lah", "اللاهندا" },
            { "lam", "اللامبا" },
            { "lez", "الليزجية" },
            { "lij", "الليغورية" },
            { "lil", "الليلويتية" },
            { "lkt", "لاكوتا" },
            { "lmo", "اللومبردية" },
            { "lol", "منغولى" },
            { "lou", "الكريولية اللويزيانية" },
            { "loz", "اللوزي" },
            { "lrc", "اللرية الشمالية" },
            { "lsm", "الساميا" },
            { "lua", "اللبا-لؤلؤ" },
            { "lui", "اللوسينو" },
            { "lun", "اللوندا" },
            { "luo", "اللو" },
            { "lus", "الميزو" },
            { "luy", "لغة اللويا" },
            { "mad", "المادريز" },
            { "mag", "الماجا" },
            { "mai", "المايثيلي" },
            { "mak", "الماكاسار" },
            { "man", "الماندينغ" },
            { "mas", "الماساي" },
            { "mde", "مابا" },
            { "mdf", "الموكشا" },
            { "mdr", "الماندار" },
            { "men", "الميند" },
            { "mer", "الميرو" },
            { "mfe", "المورسيانية" },
            { "mga", "الأيرلندية الوسطى" },
            { "mgh", "ماخاوا-ميتو" },
            { "mgo", "ميتا" },
            { "mic", "الميكماكيونية" },
            { "min", "المينانجكاباو" },
            { "mnc", "المانشو" },
            { "mni", "المانيبورية" },
            { "moe", "إينو-ايمون" },
            { "moh", "الموهوك" },
            { "mos", "الموسي" },
            { "mua", "مندنج" },
            { "mul", "لغات متعددة" },
            { "mus", "الكريك" },
            { "mwl", "الميرانديز" },
            { "mwr", "الماروارية" },
            { "myv", "الأرزية" },
            { "mzn", "المازندرانية" },
            { "nan", "مين-نان الصينية" },
            { "nap", "النابولية" },
            { "naq", "لغة الناما" },
            { "nds", "الألمانية السفلى" },
            { "new", "النوارية" },
            { "nia", "النياس" },
            { "niu", "النيوي" },
            { "nmg", "كواسيو" },
            { "nnh", "لغة النجيمبون" },
            { "nog", "النوجاي" },
            { "non", "النورس القديم" },
            { "nqo", metaValue_nqo },
            { "nso", "السوتو الشمالية" },
            { "nus", "النوير" },
            { "nwc", "النوارية التقليدية" },
            { "nym", "النيامويزي" },
            { "nyn", "النيانكول" },
            { "nyo", "النيورو" },
            { "nzi", "النزيما" },
            { "ojb", "أوجيبوا الشمالية الغربية" },
            { "ojc", "أوجيبوا الوسطى" },
            { "ojs", "الأوجي-كري" },
            { "ojw", "الأوجيبوا الغربية" },
            { "oka", "الأوكاناغانية" },
            { "osa", "الأوساج" },
            { "ota", "التركية العثمانية" },
            { "pag", "البانجاسينان" },
            { "pal", "البهلوية" },
            { "pam", "البامبانجا" },
            { "pap", "البابيامينتو" },
            { "pau", "البالوان" },
            { "pcm", "البدجنية النيجيرية" },
            { "peo", metaValue_peo },
            { "phn", metaValue_phn },
            { "pis", "بيجين" },
            { "pon", "البوهنبيايان" },
            { "pqm", "الماليزيت-باساماكودي" },
            { "prg", "البروسياوية" },
            { "pro", "البروفانسية القديمة" },
            { "quc", "الكيشية" },
            { "raj", "الراجاسثانية" },
            { "rap", "الراباني" },
            { "rar", "الراروتونجاني" },
            { "rhg", "الروهينغية" },
            { "rof", "الرومبو" },
            { "rom", "الغجرية" },
            { "rup", "الأرومانيان" },
            { "rwk", "الروا" },
            { "sad", "السانداوي" },
            { "sah", "الساخيّة" },
            { "sam", "الآرامية السامرية" },
            { "saq", "سامبورو" },
            { "sas", "الساساك" },
            { "sat", "السانتالية" },
            { "sba", "نامبي" },
            { "sbp", "سانغو" },
            { "scn", "الصقلية" },
            { "sco", "الأسكتلندية" },
            { "sdh", "الكردية الجنوبية" },
            { "see", "السنيكا" },
            { "seh", "سينا" },
            { "sel", "السيلكب" },
            { "ses", "كويرابورو سيني" },
            { "sga", "الأيرلندية القديمة" },
            { "shi", "تشلحيت" },
            { "shn", "الشان" },
            { "shu", "العربية التشادية" },
            { "sid", "السيدامو" },
            { "slh", "لوشوتسيد الجنوبية" },
            { "sma", "السامي الجنوبي" },
            { "smj", "السامي لولي" },
            { "smn", "الإيناري سامي" },
            { "sms", "السكولت سامي" },
            { "snk", "السونينك" },
            { "sog", "السوجدين" },
            { "srn", "السرانان تونجو" },
            { "srr", "السرر" },
            { "ssy", "لغة الساهو" },
            { "str", "سترايتس ساليش" },
            { "suk", "السوكوما" },
            { "sus", "السوسو" },
            { "sux", "السومارية" },
            { "swb", "القمرية" },
            { "syc", "سريانية تقليدية" },
            { "syr", metaValue_syr },
            { "szl", "السيليزية" },
            { "tce", "التوتشون الجنوبية" },
            { "tem", "التيمن" },
            { "teo", "تيسو" },
            { "ter", "التيرينو" },
            { "tet", "التيتم" },
            { "tgx", "التاغيش" },
            { "tht", "التالتان" },
            { "tig", "التيغرية" },
            { "tiv", "التيف" },
            { "tkl", "التوكيلاو" },
            { "tlh", "الكلينجون" },
            { "tli", "التلينغيتية" },
            { "tmh", "التاماشيك" },
            { "tog", "تونجا - نياسا" },
            { "tok", "التوكي-بونا" },
            { "tpi", "التوك بيسين" },
            { "trv", "لغة التاروكو" },
            { "tsi", "التسيمشيان" },
            { "ttm", "التوتشون الشمالية" },
            { "tum", "التامبوكا" },
            { "tvl", "التوفالو" },
            { "twq", "تاساواق" },
            { "tyv", "التوفية" },
            { "tzm", "الأمازيغية وسط الأطلس" },
            { "udm", "الأدمرت" },
            { "uga", "اليجاريتيك" },
            { "umb", "الأمبندو" },
            { "und", "لغة غير معروفة" },
            { "vai", metaValue_vai },
            { "vec", "البندقية" },
            { "vmw", "الماكوا" },
            { "vot", "الفوتيك" },
            { "vun", "الفونجو" },
            { "wae", "الوالسر" },
            { "wal", "الولاياتا" },
            { "war", "الواراي" },
            { "was", "الواشو" },
            { "wbp", "وارلبيري" },
            { "wuu", "الوو الصينية" },
            { "xal", "الكالميك" },
            { "xnr", "كانغري" },
            { "xog", "السوغا" },
            { "yao", "الياو" },
            { "yap", "اليابيز" },
            { "yav", "يانجبن" },
            { "ybb", "يمبا" },
            { "yrl", "النيينجاتو" },
            { "yue", "الكَنْتُونية" },
            { "zap", "الزابوتيك" },
            { "zbl", "رموز المعايير الأساسية" },
            { "zen", "الزيناجا" },
            { "zgh", "التمازيغية المغربية القياسية" },
            { "zun", "الزونية" },
            { "zxx", "بدون محتوى لغوي" },
            { "zza", "زازا" },
            { "Adlm", "أدلم" },
            { "Arab", metaValue_ar },
            { "Aran", "نستعليق" },
            { "Armn", "الأرمينية" },
            { "Bali", metaValue_pi },
            { "Batk", "الباتاك" },
            { "Beng", metaValue_bn },
            { "Blis", "رموز بليس" },
            { "Bopo", "البوبوموفو" },
            { "Brah", "الهندوسية" },
            { "Brai", "البرايل" },
            { "Bugi", "البجينيز" },
            { "Buhd", "البهيدية" },
            { "Cakm", "شاكما" },
            { "Cans", "مقاطع كندية أصلية موحدة" },
            { "Cari", "الكارية" },
            { "Cham", "التشامية" },
            { "Cher", metaValue_chr },
            { "Cirt", "السيرث" },
            { "Copt", metaValue_cop },
            { "Cprt", "القبرصية" },
            { "Cyrl", "السيريلية" },
            { "Cyrs", "السيريلية السلافية الكنسية القديمة" },
            { "Deva", "الديفاناجاري" },
            { "Dsrt", "الديسيريت" },
            { "Egyd", "الديموطيقية" },
            { "Egyh", "الهيراطيقية" },
            { "Egyp", "الهيروغليفية" },
            { "Ethi", "الأثيوبية" },
            { "Geok", "الأبجدية الجورجية - أسومتافرلي و نسخري" },
            { "Geor", metaValue_ka },
            { "Glag", "الجلاجوليتيك" },
            { "Goth", metaValue_got },
            { "Grek", metaValue_el },
            { "Gujr", "التاغجراتية" },
            { "Guru", "الجرمخي" },
            { "Hanb", "هانب" },
            { "Hang", "الهانغول" },
            { "Hani", "الهان" },
            { "Hano", "الهانونو" },
            { "Hans", "المبسطة" },
            { "Hant", "التقليدية" },
            { "Hebr", metaValue_he },
            { "Hira", "الهيراجانا" },
            { "Hmng", "الباهوه همونج" },
            { "Hrkt", "أبجدية مقطعية يابانية" },
            { "Hung", "المجرية القديمة" },
            { "Inds", "اندس - هارابان" },
            { "Ital", "الإيطالية القديمة" },
            { "Jamo", "جامو" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Kali", "الكياه لى" },
            { "Kana", "الكتكانا" },
            { "Khar", "الخاروشتى" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Lana", "الانا" },
            { "Laoo", "اللاو" },
            { "Latf", "اللاتينية - متغير فراكتر" },
            { "Latg", "اللاتينية - متغير غيلى" },
            { "Latn", metaValue_la },
            { "Lepc", "الليبتشا - رونج" },
            { "Limb", "الليمبو" },
            { "Lina", "الخطية أ" },
            { "Linb", "الخطية ب" },
            { "Lyci", "الليسية" },
            { "Lydi", "الليدية" },
            { "Mand", "المانداينية" },
            { "Maya", "المايا الهيروغليفية" },
            { "Mero", "الميرويتيك" },
            { "Mlym", "الماليالام" },
            { "Mong", "المغولية" },
            { "Moon", "مون" },
            { "Mtei", "ميتي ماييك" },
            { "Mymr", "الميانمار" },
            { "Narb", "العربية الشمالية القديمة" },
            { "Nkoo", metaValue_nqo },
            { "Ogam", "الأوجهام" },
            { "Olck", "أول تشيكي" },
            { "Orkh", "الأورخون" },
            { "Orya", "الأوريا" },
            { "Osma", "الأوسمانيا" },
            { "Perm", "البيرميكية القديمة" },
            { "Phag", "الفاجسبا" },
            { "Phnx", metaValue_phn },
            { "Plrd", "الصوتيات الجماء" },
            { "Qaag", "زوجيي" },
            { "Rohg", "الحنيفي" },
            { "Roro", "رنجورنجو" },
            { "Runr", "الروني" },
            { "Sara", "الساراتي" },
            { "Sarb", "العربية الجنوبية القديمة" },
            { "Shaw", "الشواني" },
            { "Sinh", "السينهالا" },
            { "Sund", metaValue_su },
            { "Sylo", "السيلوتي ناغري" },
            { "Syrc", metaValue_syr },
            { "Syre", "السريانية الأسترنجيلية" },
            { "Syrj", "السريانية الغربية" },
            { "Syrn", "السريانية الشرقية" },
            { "Tagb", "التاجبانوا" },
            { "Tale", "التاي لي" },
            { "Talu", "التاى لى الجديد" },
            { "Taml", metaValue_ta },
            { "Telu", "التيلجو" },
            { "Teng", "التينجوار" },
            { "Tfng", "التيفيناغ" },
            { "Tglg", "التغالوغية" },
            { "Thaa", "الثعنة" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Ugar", "الأجاريتيكية" },
            { "Vaii", metaValue_vai },
            { "Visp", "الكلام المرئي" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "الكتابة المسمارية الأكدية السومرية" },
            { "Yiii", "اليي" },
            { "Zinh", "الموروث" },
            { "Zmth", "تدوين رياضي" },
            { "Zsye", "إيموجي" },
            { "Zsym", "رموز" },
            { "Zxxx", "غير مكتوب" },
            { "Zyyy", "عام" },
            { "Zzzz", "نظام كتابة غير معروف" },
            { "de_AT", "الألمانية النمساوية" },
            { "es_ES", "الإسبانية الأوروبية" },
            { "es_MX", "الإسبانية المكسيكية" },
            { "fa_AF", "الدارية" },
            { "pt_BR", "البرتغالية البرازيلية" },
            { "pt_PT", "البرتغالية الأوروبية" },
            { "ro_MD", "المولدوفية" },
            { "sw_CD", "الكونغو السواحلية" },
            { "%%1901", "التهجئة الألمانية التقليدية" },
            { "%%1996", "التهجئة الألمانية لعام 1996" },
            { "ar_001", "العربية الفصحى الحديثة" },
            { "es_419", "الإسبانية أمريكا اللاتينية" },
            { "key.ca", "التقويم" },
            { "key.cf", "تنسيق العملة" },
            { "key.co", "ترتيب الفرز" },
            { "key.cu", "العملة" },
            { "key.em", "عرض الرموز التعبيرية" },
            { "key.hc", "نظام التوقيت (12 مقابل 24)" },
            { "key.lb", "نمط فصل السطور" },
            { "key.lw", "فصل السطور وسط الكلمات" },
            { "key.ms", "نظام القياس" },
            { "key.nu", "الأرقام" },
            { "key.ss", "فاصل الجملة بعد الاختصار" },
            { "key.tz", "المنطقة الزمنية" },
            { "key.va", "متغيرات اللغة" },
            { "nds_NL", "السكسونية السفلى" },
            { "%%KKCOR", "التهجئة العامة" },
            { "%%NEDIS", "لهجة ناتيسون" },
            { "%%POSIX", "حاسوب" },
            { "%%UCCOR", "التهجئة الموحدة" },
            { "zh_Hans", "الصينية المبسطة" },
            { "zh_Hant", "الصينية التقليدية" },
            { "%%PINYIN", "بينيين باللاتينية" },
            { "%%UCRCOR", "التهجئة المراجعة الموحدة" },
            { "%%AREVELA", "أرمنية شرقية" },
            { "%%AREVMDA", "أرمنية غربية" },
            { "%%MONOTON", "أحادي النغمة" },
            { "%%POLYTON", "متعدد النغمات" },
            { "%%REVISED", "تهجئة تمت مراجعتها" },
            { "%%1959ACAD", "أكاديمي" },
            { "%%BAKU1926", "الأبجدية التركية اللاتينية الموحدة" },
            { "%%SCOTLAND", "الإنجليزية الأسكتلندنية الرسمية" },
            { "%%VALENCIA", "بلنسية" },
            { "%%WADEGILE", "المندرين باللاتينية - ويد–جيلز" },
            { "type.ca.roc", "تقويم مينجو" },
            { "type.hc.h11", "نظام 12 ساعة (0–11)" },
            { "type.hc.h12", "نظام 12 ساعة (1–12)" },
            { "type.hc.h23", "نظام 24 ساعة (0–23)" },
            { "type.hc.h24", "نظام 24 ساعة (1–24)" },
            { "type.m0.bgn", "بي جي إن" },
            { "type.nu.arab", "الأرقام العربية الهندية" },
            { "type.nu.armn", "الأرقام الأرمينية" },
            { "type.nu.beng", "الأرقام البنغالية" },
            { "type.nu.cakm", "أرقام تشاكما" },
            { "type.nu.deva", "الأرقام الديفانغارية" },
            { "type.nu.ethi", "الأرقام الإثيوبية" },
            { "type.nu.geor", "الأرقام الجورجية" },
            { "type.nu.grek", "الأرقام اليونانية" },
            { "type.nu.gujr", "الأرقام الغوجاراتية" },
            { "type.nu.guru", "الأرقام الغورموخية" },
            { "type.nu.hans", "الأرقام الصينية المبسطة" },
            { "type.nu.hant", "الأرقام الصينية التقليدية" },
            { "type.nu.hebr", "الأرقام العبرية" },
            { "type.nu.java", "الأرقام الجاوية" },
            { "type.nu.jpan", "الأرقام اليابانية" },
            { "type.nu.khmr", "الأرقام الخيمرية" },
            { "type.nu.knda", "أرقام الكانادا" },
            { "type.nu.laoo", "الأرقام اللاوية" },
            { "type.nu.latn", "الأرقام الغربية" },
            { "type.nu.mlym", "الأرقام الملايلامية" },
            { "type.nu.mong", "الأرقام المغولية" },
            { "type.nu.mtei", "أرقام ميتي" },
            { "type.nu.mymr", "أرقام ميانمار" },
            { "type.nu.olck", "أرقام أُول تشيكي" },
            { "type.nu.orya", "أرقام الأوريا" },
            { "type.nu.taml", "الأرقام التاميلية التقليدية" },
            { "type.nu.telu", "الأرقام التيلوغوية" },
            { "type.nu.thai", "الأرقام التايلاندية" },
            { "type.nu.tibt", "الأرقام التبتية" },
            { "type.nu.vaii", "أرقام فاي" },
            { "type.ca.dangi", "تقويم دانجي" },
            { "type.co.ducet", "ترتيب فرز Unicode الافتراضي" },
            { "type.lb.loose", "نمط فصل السطور: متباعد" },
            { "type.nu.roman", "الأرقام الرومانية" },
            { "type.ca.coptic", "التقويم القبطي" },
            { "type.ca.hebrew", "التقويم العبري" },
            { "type.ca.indian", "التقويم القومي الهندي" },
            { "type.co.compat", "ترتيب الفرز السابق: للتوافق" },
            { "type.co.pinyin", "الترتيب حسب نظام بنيين الصيني" },
            { "type.co.search", "بحث لأغراض عامة" },
            { "type.co.stroke", "الترتيب حسب نظام كتابة المجموع الصيني" },
            { "type.co.unihan", "الترتيب حسب نظام الكتابة بالجذر والمجموع" },
            { "type.co.zhuyin", "الترتيب حسب نظام بوبوموفو" },
            { "type.d0.fwidth", "عرض كامل" },
            { "type.d0.hwidth", "نصف العرض" },
            { "type.lb.normal", "نمط فصل السطور: عادي" },
            { "type.lb.strict", "نمط فصل السطور: متقارب" },
            { "type.m0.ungegn", "يو إن جي إي جي إن" },
            { "type.ms.metric", "النظام المتري" },
            { "type.nu.native", "الأرقام الأصلية" },
            { "type.ca.chinese", "التقويم الصيني" },
            { "type.ca.islamic", "التقويم الهجري" },
            { "type.ca.iso8601", "تقويم ISO-8601" },
            { "type.ca.persian", "التقويم الفارسي" },
            { "type.cf.account", "تنسيق العملة للحسابات" },
            { "type.d0.npinyin", "رقمي" },
            { "type.nu.arabext", "الأرقام العربية الهندية الممتدة" },
            { "type.nu.armnlow", "الأرقام الأرمينية الصغيرة" },
            { "type.nu.finance", "الأرقام المالية" },
            { "type.nu.greklow", "الأرقام اليونانية الصغيرة" },
            { "type.nu.hanidec", "الأرقام العشرية الصينية" },
            { "type.nu.hansfin", "الأرقام المالية الصينية المبسطة" },
            { "type.nu.hantfin", "الأرقام المالية الصينية التقليدية" },
            { "type.nu.jpanfin", "الأرقام المالية اليابانية" },
            { "type.nu.tamldec", "الأرقام التاميلية" },
            { "type.ca.buddhist", "التقويم البوذي" },
            { "type.ca.ethiopic", "التقويم الإثيوبي" },
            { "type.ca.japanese", "التقويم الياباني" },
            { "type.cf.standard", "تنسيق العملة القياسي" },
            { "type.co.phonetic", "الترتيب حسب اللفظ" },
            { "type.co.searchjl", "بحث باستخدام حرف الهانغول الساكن الأول" },
            { "type.co.standard", "ترتيب الفرز القياسي" },
            { "type.ms.uksystem", "نظام القياس البريطاني" },
            { "type.ms.ussystem", "نظام القياس الأمريكي" },
            { "type.nu.fullwide", "أرقام كاملة العرض" },
            { "type.nu.romanlow", "الأرقام الرومانية الصغيرة" },
            { "type.ca.gregorian", "التقويم الميلادي" },
            { "type.co.phonebook", "الترتيب حسب دليل الهاتف" },
            { "type.co.dictionary", "الترتيب حسب القاموس" },
            { "type.co.traditional", "ترتيب تقليدي" },
            { "type.nu.traditional", "أرقام تقليدية" },
            { "type.ca.islamic-rgsa", "التقويم الهجري (السعودية - الرؤية)" },
            { "type.ca.islamic-tbla", "التقويم الهجري (الحسابات الفلكية)" },
            { "type.ca.islamic-civil", "التقويم الهجري المدني" },
            { "ListCompositionPattern", "{0}، {1}" },
            { "type.ca.islamic-umalqura", "التقويم الهجري (أم القرى)" },
            { "type.ca.ethiopic-amete-alem", "تقويم أميتي أليم الإثيوبي" },
        };
        return data;
    }
}
