/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.loader;

import java.util.List;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.loader.OuterJoinLoader;
import net.sf.hibernate.persister.Loadable;
import net.sf.hibernate.sql.JoinFragment;
import net.sf.hibernate.sql.Select;

public abstract class AbstractEntityLoader
extends OuterJoinLoader {
    protected final Loadable persister;
    protected String alias;

    public AbstractEntityLoader(Loadable persister, SessionFactoryImplementor factory) {
        super(factory.getDialect());
        this.persister = persister;
        this.alias = OuterJoinLoader.alias(persister.getClassName(), 0);
    }

    protected void renderStatement(String condition, SessionFactoryImplementor factory) throws MappingException {
        this.renderStatement(condition, "", factory);
    }

    protected void renderStatement(String condition, String orderBy, SessionFactoryImplementor factory) throws MappingException {
        List associations = this.walkTree(this.persister, this.alias, factory);
        int joins = associations.size();
        this.suffixes = new String[joins + 1];
        int i = 0;
        while (i <= joins) {
            this.suffixes[i] = joins == 0 ? "" : Integer.toString(i) + '_';
            ++i;
        }
        JoinFragment ojf = this.outerJoins(associations);
        this.sql = new Select().setSelectClause((joins == 0 ? "" : this.selectString(associations) + ", ") + OuterJoinLoader.selectString(this.persister, this.alias, this.suffixes[joins])).setFromClause(this.persister.fromTableFragment(this.alias) + this.persister.fromJoinFragment(this.alias, true, true)).setWhereClause(condition).setOuterJoins(ojf.toFromFragmentString(), ojf.toWhereFragmentString() + this.persister.whereJoinFragment(this.alias, true, true)).setOrderByClause(orderBy).toStatementString();
        this.classPersisters = new Loadable[joins + 1];
        this.lockModeArray = this.createLockModeArray(joins + 1, LockMode.NONE);
        int i2 = 0;
        while (i2 < joins) {
            this.classPersisters[i2] = ((OuterJoinLoader.OuterJoinableAssociation)associations.get((int)i2)).subpersister;
            ++i2;
        }
        this.classPersisters[joins] = this.persister;
    }
}

