/* { dg-do run { target { riscv_v } } } */
/* { dg-options "-O2" } */

#include<cmath>
#include<cstddef>
#include<cstdint>
#include<iomanip>
#include<ios>
#include<iostream>
#include<memory>
#include<type_traits>
#include"riscv_vector.h"
using std::addressof;
using std::cerr;
using std::endl;
using std::int8_t;
using std::int16_t;
using std::int32_t;
using std::int64_t;
using std::uint8_t;
using std::uint16_t;
using std::uint32_t;
using std::uint64_t;
using std::ptrdiff_t;
using std::size_t;
using float16_t = _Float16;
using float32_t = float;
using float64_t = double;

template<class T, class T2>
constexpr T uint_to_float(T2 val) noexcept
{
  return *reinterpret_cast<T*>(&val);
}

constexpr const auto &f16(uint_to_float<float16_t, uint16_t>);
constexpr const auto &f32(uint_to_float<float32_t, uint32_t>);
constexpr const auto &f64(uint_to_float<float64_t, uint64_t>);

template<class T>
struct To_uint
{
  using type = std::conditional_t<
    sizeof(T) == 1, uint8_t, std::conditional_t<
      sizeof(T) == 2, uint16_t, std::conditional_t<
        sizeof(T) == 4, uint32_t, std::conditional_t<
          sizeof(T) == 8, uint64_t, void
        >
      >
    >
  >;
};

// isnan() does not support half type
template<class T>
struct To_float
{
  using type = std::conditional_t<
    std::is_same<T, float16_t>::value, float, std::conditional_t<
      std::is_same<T, float32_t>::value, float, std::conditional_t<
        std::is_same<T, float64_t>::value, double, float
      >
    >
  >;
};

template<class T>
using To_uint_t = typename To_uint<T>::type;

template<class T>
using To_isnan_float = typename To_float<T>::type;

template <class T>
void print_float(std::ostream &os, T val)
{
  using std::setw;
  os << std::hex << std::setfill('0') << setw(sizeof(T) * 2) << *reinterpret_cast<To_uint_t<T>*>(addressof(val)) << setw(0) << std::dec;
}

template <class T>
bool __attribute__((noinline))
check(const T *a, const T *b, size_t size)
{
  bool rv = true;
  for (size_t i = 0; i < (size / sizeof(T)); ++i) {
    if (reinterpret_cast<const To_uint_t<T> *>(a)[i] ==
        reinterpret_cast<const To_uint_t<T> *>(b)[i])
      continue;
    // floating negative zero == positive zero
    if ((std::is_floating_point_v<T> || std::is_same<T, float16_t>::value) &&
        (a[i] == b[i]))
      continue;
    // if both result are NaN, return true
    if ((std::is_same<T, float16_t>::value || std::is_floating_point_v<T>) &&
         std::isnan(static_cast<To_isnan_float<T>>(a[i])) &&
         std::isnan(static_cast<To_isnan_float<T>>(b[i])))
      continue;

    if (std::is_same<T, float16_t>::value) {
      cerr << std::hex << std::setfill('0') << std::setw(sizeof(T) * 2) << "["
           << i
           << "] result/golden:" << reinterpret_cast<const To_uint_t<T> *>(a)[i]
           << " != " << reinterpret_cast<const To_uint_t<T> *>(b)[i]
           << std::setw(0) << std::dec << endl;
    } else if constexpr (std::is_floating_point_v<T>) {
      cerr << "[" << i << "] result/golden:" << a[i] << "(";
      print_float(cerr, a[i]);
      cerr << ") != " << b[i] << "(";
      print_float(cerr, b[i]);
      cerr << ")" << endl;
    } else if constexpr (std::is_unsigned_v<T>) {
      cerr << "[" << i << "] result/golden: " << static_cast<uintmax_t>(a[i])
           << " != " << static_cast<uintmax_t>(b[i]) << endl;
    } else {
      cerr << "[" << i << "] result/golden:" << static_cast<intmax_t>(a[i])
           << " != " << static_cast<intmax_t>(b[i]) << endl;
    }
    rv = false;
  }
  return rv;
}

template <class T>
bool __attribute__((noinline))
check(const T a, const T golden)
{
  return check(addressof(a), addressof(golden), sizeof(T));
}



int main()
{
int return_value = 0;

size_t var_90 = 11u;
int8_t var_89 [] = {-10, -30, 64, 34, 48, 121, 26, 30, 39, 91, 112};
size_t var_87 = 62u;
int8_t var_86 [] = {-4, -13, 31, 8, -128, 11, -20, -97, 104, 29, 70, -71, 61, -79, -7, 34, -60, 55, -112, -30, 79, -106, -122, 55, -126, 50, -47, 33, 119, 5, 13, 32, 97, 106, -26, 89, -125, -6, 39, -39, 91, -39, 58, -97, 46, 107, 27, -16, -61, -44, -63, 45, 1, 121, 85, 50, 85, 105, 8, -92, 45, 124};
size_t var_84 = 38u;
int8_t var_83 [] = {-82, 72, 66, -17, -23, -48, 5, 3, 26, -35, 13, 89, -79, -73, 48, 84, -75, 15, -101, 107, -56, -113, -128, 79, -112, 41, 22, 17, 87, 98, 127, 95, 37, -6, 24, 127, 106, 87};
size_t var_81 = 113u;
int8_t var_80 [] = {68, 9, 20, 85, -11, -94, 50, -10, -103, 45, 64, -85, -55, 9, -45, 17, -83, -65, -56, -41, 105, 109, 84, -62, -103, -9, -78, -90, -52, 26, -82, -38, -59, 75, -12, -93, 99, -56, -20, 100, -93, 100, -6, -121, 25, 125, 50, -14, 105, -94, -96, -100, -116, -10, 25, 16, -64, -124, -122, 121, -36, -12, 116, 42, -47, 29, 32, 53, -122, 58, 29, 64, -58, -47, -62, -79, -103, 113, -12, -38, -13, 68, 30, -85, 21, 101, 35, 2, -17, -77, 84, -77, 12, 18, -55, -114, -77, 83, -19, -33, 9, -27, 57, -25, 114, 72, 12, 23, -42, 2, -118, 12, 34};
size_t var_78 = 45u;
int8_t var_77 [] = {-32, -29, -23, -14, -26, -71, -25, -26, -108, -19, 95, -33, -25, -34, 6, 76, -9, 116, 113, -32, -42, 81, -28, -31, -112, -29, 80, -6, -94, -30, 120, 117, 97, -97, -2, -57, -23, -34, -79, 2, -103, 123, -28, -28, 116};
size_t var_75 = 37u;
int8_t var_74 [] = {-19, -121, -119, -20, -22, -105, 30, 80, -121, 18, 114, -80, -62, -69, 51, -16, 98, -59, -72, 77, -50, -68, -72, 20, -15, 28, 54, -12, 17, 107, -72, 61, -108, -117, -19, 109, -120};
size_t var_72 = 8u;
int8_t var_71 [] = {77, 63, -96, 96, 58, 91, 105, -52};
size_t var_69 = 34u;
int8_t var_68 [] = {-44, -29, -23, -29, -26, -45, -25, -26, -28, -19, -28, -33, -25, -33, -17, -37, -9, -16, -20, -32, -42, -19, -28, -31, -31, -29, -51, -6, -26, -30, -31, -32, -17, -29};
int8_t var_66 [] = {-44, 5, -86, 121, 12, -68, -40, -34, 49, -59, 1, -107, 97, 99, 88, 78, -56, 100, -19, 94, -128, -84, 95, 61, -94, 8, 95, -12, -84, 97, -124, 53, 96, 117};
int8_t var_65 [] = {77, 34, 103, -67, 126, 99, 35, 48};
int8_t var_64 [] = {-19, -121, -119, -20, -22, -105, 30, 80, -121, 18, 114, -80, -62, -69, 51, -16, 98, -59, -72, 77, -50, -68, -72, 20, -15, 28, 54, -12, 17, 107, -72, 61, -108, -117, -19, 109, -120};
int8_t var_63 [] = {10, -34, 0, -14, 49, -71, -58, -81, -108, -14, 95, -99, 45, -34, 6, 76, -43, 116, 113, 77, -20, 81, -70, -11, -112, -123, 80, -110, -94, 86, 120, 117, 97, -97, -2, -57, -5, -27, -79, 2, -103, 123, -94, -63, 116};
int8_t var_62 [] = {-113, -23, -71, 85, -106, -94, -74, 32, -103, 21, 64, -101, 27, 9, -45, 17, -10, -65, -56, 48, 41, 109, -99, -61, -103, -102, -78, -53, -52, 41, -82, -38, -59, 75, -12, -93, 3, -14, -20, 100, -93, 100, 81, -126, 25, 125, -7, 26, 105, -94, -109, -29, 58, 51, 25, 9, -64, -124, -122, 79, -36, -12, -105, 42, -47, -117, 32, 28, -122, 58, 29, 40, -58, -41, -62, -79, -103, 37, -12, -38, -13, 68, 30, -12, 21, 101, 43, 2, -17, -105, 84, -77, 12, 18, -66, -114, -77, 83, 101, -33, -82, -27, 57, 84, 114, -26, -59, 58, -42, 2, -84, 12, 34};
int8_t var_61 [] = {-54, 43, -117, -17, -52, -48, 121, -48, 26, 81, 13, -51, 62, -73, 48, 84, -83, 15, -101, 52, -62, -113, 65, -9, -112, 50, 22, -30, 87, -12, 127, 95, 37, -6, 24, 127, 66, 115};
int8_t var_60 [] = {-32, -77, -78, 8, 46, 11, 29, -42, 104, 16, 70, -126, -128, -79, -7, 34, 78, 55, -112, 71, 11, -106, 101, 119, -126, -45, -47, -64, 119, 124, 13, 32, 97, 106, -26, 89, 127, -87, 39, -39, 91, -39, -5, -9, 46, 107, -22, -4, -61, -44, 63, 54, 71, -125, 85, -108, 85, 105, 8, -42, 45, 124};
int8_t var_59 [] = {106, 127, 42, -59, -84, 112, 107, -107, 5, 84, 18};
uint8_t var_58 [] = {41u, 46u, 209u, 127u, 2u, 89u, 89u, 118u, 23u, 89u, 191u, 1u, 39u, 217u, 93u, 44u, 209u, 226u, 133u, 115u, 49u, 209u, 105u, 36u, 227u, 83u, 14u, 47u, 124u, 27u, 181u, 154u, 23u, 218u, 238u, 141u, 72u, 191u, 208u, 1u, 198u, 60u, 75u, 85u, 117u, 172u, 208u, 51u, 125u, 204u, 244u, 26u, 161u, 102u, 151u, 215u, 222u, 121u, 33u, 31u, 127u, 89u, 36u, 18u, 59u, 96u, 123u, 51u, 63u, 179u, 200u, 238u, 90u, 95u, 159u, 237u, 110u, 247u, 201u, 129u, 94u, 13u, 245u, 122u, 46u, 25u, 128u, 102u, 15u, 54u, 139u, 206u, 173u, 158u, 75u, 16u, 29u, 219u, 238u, 120u, 163u, 239u, 250u, 212u, 160u, 9u, 52u, 36u, 165u, 118u, 50u, 202u, 30u};
int8_t var_57 [] = {-22, -22, -113, 5, -12, -43, 39, -45};
int8_t var_56 [] = {-45, 81, 83, 47, 97, -15, 40, 72};
int8_t var_55 [] = {105, 6, 16, -46, 37, 91, 61, 41};
uint64_t var_54 [] = {1216632416317310618u, 13918972806200148495u, 9480163460113362192u, 3100536681756667587u, 9224371562617342204u, 1410358863554626201u, 12812188570884775094u, 7800321671861261197u};
uint64_t var_53 [] = {8866603672203376802u, 14619974357936077740u, 11734407410030572282u, 5213502474894882192u, 3669049798112016461u, 4244506456339766837u, 16560998825617301671u, 15380043380001599186u};
int8_t var_52 [] = {-10, -30, 64, 34, 48, 121, 26, 30, 39, 91, 112};
uint8_t var_51 [] = {134u, 207u, 176u, 214u, 99u, 29u, 124u, 85u, 53u, 163u, 51u, 179u, 201u, 118u, 41u, 24u, 246u, 136u, 17u, 79u, 255u, 223u, 57u, 237u, 226u, 168u, 123u, 95u, 158u, 221u, 70u, 108u, 205u, 127u, 51u, 133u, 120u, 224u, 28u, 58u, 62u, 53u, 222u, 217u, 66u, 33u, 220u, 147u, 42u, 63u, 198u, 186u, 147u, 133u, 10u, 235u, 157u, 86u, 58u, 76u, 127u, 167u, 213u, 12u, 72u, 124u, 39u, 129u, 139u, 148u, 9u, 66u, 53u, 84u, 35u, 20u, 148u, 248u, 109u, 113u, 89u, 24u, 15u, 248u, 1u, 223u, 196u, 143u, 192u, 152u, 136u, 39u, 187u, 27u, 120u, 162u, 27u, 183u, 207u, 80u, 178u, 2u, 97u, 194u, 89u, 176u, 144u, 242u, 118u, 111u, 116u, 146u, 79u};
uint8_t var_50 [] = {45u, 97u, 36u, 243u, 43u, 253u, 96u, 6u, 88u, 150u, 119u, 57u, 134u, 200u, 174u, 176u, 156u, 240u, 144u, 45u, 19u, 230u, 14u, 225u, 255u, 119u, 140u, 33u, 197u, 107u, 163u, 179u, 251u, 140u, 242u, 213u, 36u, 70u, 217u, 103u, 111u, 225u, 75u, 35u, 211u, 159u, 47u, 88u, 188u, 111u, 44u, 91u, 99u, 111u, 116u, 199u, 196u, 255u, 201u, 15u, 186u, 204u, 77u, 142u, 227u, 66u, 156u, 72u, 219u, 223u, 202u, 59u, 109u, 36u, 242u, 99u, 184u, 139u, 247u, 127u, 240u, 236u, 36u, 98u, 74u, 232u, 56u, 176u, 219u, 85u, 253u, 57u, 248u, 73u, 115u, 184u, 62u, 252u, 135u, 205u, 36u, 238u, 103u, 35u, 229u, 170u, 12u, 1u, 129u, 145u, 99u, 153u, 131u};
int8_t var_49 [] = {-22, -52, -52, 96, -33, 88, -35, -115, 98, -108, -56, 109, 64, -117, -88, -2, -23, 108, -111, -120, 72, 32, 2, 55, -103, -72, 92, 121, 51, 51, -94, -72, -97, -41, -98, 19, -128, 91, -76, 31, -31, 119, -80, -60, -107, 96, 59, -119, 32, -25, -80, -55, 116, -102, -120, 54, 25, -38, -20, 108, 0, 14, 3, 17, -16, -109, -39, -57, -34, -116, 127, -17, 63, -17, -54, -59, 40, 121, -22, 71, 18, -125, -115, -89, -31, -121, -116, -29, 37, 50, -89, -84, -26, 127, -18, -16, 32, 114, 5, -117, -83, -73, -83, -27, -119, -68, 123, -95, 89, -119, 38, 15, 19};
int8_t var_48 [] = {-75, -8, 2, 9, 84, 7, -73, -74, -76, 116, 102, 38, 92, -72, 44, -56, 116, -104, 114, -47, 89, -79, -117, -76, -6, 8, 94, -27, -55, 102, -64, 48, 92, -105, -43, 73, 7, -1, -65, 54, 108, 88, 54, 73, 93, 7, -12, 41, 26, -44, 29, 41, 28, 61, -42, -68, -62, 53, -27, 43, -112, 122, -80, -36, -32, 106, 44, -1, 31, -125, 78, -7, -41, -74, -85, -42, 123, -18, 56, -56, 73, 36, -112, -3, 26, -119, -3, -30, -82, -52, -95, -85, -13, 49, -57, -88, -66, -26, 10, -124, -86, 87, -6, -60, 53, -59, 20, 127, 30, -100, -46, 36, -86};
int8_t var_47 [] = {-4, -13, 31, -32, -128, -68, -20, -97, -96, 29, 91, -71, 61, -90, -83, 69, -60, -95, 88, -30, 79, -79, -122, 55, 112, 50, 11, 33, -100, 5, -60, -40, -109, 126, -56, -73, -125, -6, 56, -43, 78, -64, 58, -97, -66, 51, 27, -16, -16, 91, -63, 45, 1, 121, -78, 50, -22, 68, 5, -92, 56, -74};
int8_t var_46 [] = {-82, 72, 66, -104, -23, -55, 5, 3, 63, -35, -38, 89, -79, -14, -51, -101, -75, -104, -23, 107, -56, 101, -128, 79, 123, 41, 59, 17, 7, 98, 81, 15, 33, 16, -30, 72, 106, 87};
int8_t var_45 [] = {56, -64, 44, 61, 4, -87, 4, -59, -123, -18, 103, 25, -118, -21, 57, 92, -57, -53, -3, 15, 127, 93, 71, 116, 124, 37, -73, 82, -113, 97, 63, 85, 67, -83, -31, -62, -15, 46, -10, 76, 14, -73, 37, 88, -53};
int8_t var_44 [] = {118, 56, -80, -74, 123, -105, 65, 36, -40, -48, -22, 104, -78, 100, 96, 47, -93, -94, -42, -37, 106, -63, -56, 116, -12, -73, 121, -11, -64, -76, 28, -108, 71, -37, 84, -78, -54, 26, 3, 35, 32, 38, -31, 52, -100, -82, -25, -73, 89, 98, 116, 92, -44, 35, 36, 65, 65, 102, -72, 118, 27, -46, 58, -114, -15, -18, 18, -68, -63, -82, 20, -114, -49, -81, 106, 29, -118, -66, -19, -15, 104, 102, 27, 99, -54, 50, 10, -37, 60, 54, 28, -91, 12, 39, 27, -35, 1, -46, 112, -37, -127, 62, -102, 27, -71, -23, 87, 68, -19, -48, -12, 32, -6};
int8_t var_43 [] = {32, 57, -12, 44, 99, -31, -100, -34, -80, 77, 23, -69, 125, -46, -40, 54, -85, 53, 23, 5, 77, 7, 36, -54, -51, 61, -55, -104, -12, -94, -90, -41, -95, -101, 49, 89, 7, -116, -117, -41, -93, -30, -92, 15, -74, 81, 88, 56, 72, -20, -88, -76, 84, -12, -88, 122, 93, 97, 8, 85, 127, -64, 120, 29, -17, -87, 115, 13, -37, 91, 47, 12, 15, -57, 65, 34, -30, 29, 111, 107, -90, -8, 58, 41, 118, 17, 71, -12, -24, 15, -82, -23, 54, 98, 119, 106, -20, -19, 77, -120, -13, -52, -13, -107, -45, 66, -110, 63, 116, -18, -110, -46, 36};
int8_t var_42 [] = {-32, -62, 117, 7, -76, 85, 30, -77, -3, 102, 6, 28, -32, -25, 58, -98, -115, -67, -94, 46, -69, -77, 1, 25, 116, 55, -97, -126, -12, -46, -50, 19, 79, 20, -126, 29, 25, 51, -112, -128, 57, 28, 33, 2, -102};
int8_t var_41 [] = {58, 54, -116, -86, 69, -60, 55, -42};
uint8_t var_40 = 253u;
__riscv_vsetvl_e8m8(113);
vuint8m8_t var_20 = __riscv_vle8_v_u8m8(var_58, 113);
// 41, 46, 209, 127, 2, 89, 89, 118, 23, 89, 191, 1, 39, 217, 93, 44, 209, 226, 133, 115, 49, 209, 105, 36, 227, 83, 14, 47, 124, 27, 181, 154, 23, 218, 238, 141, 72, 191, 208, 1, 198, 60, 75, 85, 117, 172, 208, 51, 125, 204, 244, 26, 161, 102, 151, 215, 222, 121, 33, 31, 127, 89, 36, 18, 59, 96, 123, 51, 63, 179, 200, 238, 90, 95, 159, 237, 110, 247, 201, 129, 94, 13, 245, 122, 46, 25, 128, 102, 15, 54, 139, 206, 173, 158, 75, 16, 29, 219, 238, 120, 163, 239, 250, 212, 160, 9, 52, 36, 165, 118, 50, 202, 30

__riscv_vsetvl_e8mf2(8);
vint8mf2_t var_22 = __riscv_vle8_v_i8mf2(var_57, 8);
// -22, -22, -113, 5, -12, -43, 39, -45

vint8mf2_t var_23 = __riscv_vle8_v_i8mf2(var_56, 8);
// -45, 81, 83, 47, 97, -15, 40, 72

vint8mf2_t var_24 = __riscv_vle8_v_i8mf2(var_55, 8);
// 105, 6, 16, -46, 37, 91, 61, 41

vuint64m4_t var_25 = __riscv_vle64_v_u64m4(var_54, 8);
// 1216632416317310618, 13918972806200148495, 9480163460113362192, 3100536681756667587, 9224371562617342204, 1410358863554626201, 12812188570884775094, 7800321671861261197

vuint64m4_t var_26 = __riscv_vle64_v_u64m4(var_53, 8);
// 8866603672203376802, 14619974357936077740, 11734407410030572282, 5213502474894882192, 3669049798112016461, 4244506456339766837, 16560998825617301671, 15380043380001599186

__riscv_vsetvl_e8m8(11);
vint8m8_t var_27 = __riscv_vle8_v_i8m8(var_52, 11);
// -10, -30, 64, 34, 48, 121, 26, 30, 39, 91, 112

__riscv_vsetvl_e8m8(113);
vuint8m8_t var_29 = __riscv_vle8_v_u8m8(var_51, 113);
// 134, 207, 176, 214, 99, 29, 124, 85, 53, 163, 51, 179, 201, 118, 41, 24, 246, 136, 17, 79, 255, 223, 57, 237, 226, 168, 123, 95, 158, 221, 70, 108, 205, 127, 51, 133, 120, 224, 28, 58, 62, 53, 222, 217, 66, 33, 220, 147, 42, 63, 198, 186, 147, 133, 10, 235, 157, 86, 58, 76, 127, 167, 213, 12, 72, 124, 39, 129, 139, 148, 9, 66, 53, 84, 35, 20, 148, 248, 109, 113, 89, 24, 15, 248, 1, 223, 196, 143, 192, 152, 136, 39, 187, 27, 120, 162, 27, 183, 207, 80, 178, 2, 97, 194, 89, 176, 144, 242, 118, 111, 116, 146, 79

vuint8m8_t var_30 = __riscv_vle8_v_u8m8(var_50, 113);
// 45, 97, 36, 243, 43, 253, 96, 6, 88, 150, 119, 57, 134, 200, 174, 176, 156, 240, 144, 45, 19, 230, 14, 225, 255, 119, 140, 33, 197, 107, 163, 179, 251, 140, 242, 213, 36, 70, 217, 103, 111, 225, 75, 35, 211, 159, 47, 88, 188, 111, 44, 91, 99, 111, 116, 199, 196, 255, 201, 15, 186, 204, 77, 142, 227, 66, 156, 72, 219, 223, 202, 59, 109, 36, 242, 99, 184, 139, 247, 127, 240, 236, 36, 98, 74, 232, 56, 176, 219, 85, 253, 57, 248, 73, 115, 184, 62, 252, 135, 205, 36, 238, 103, 35, 229, 170, 12, 1, 129, 145, 99, 153, 131

vint8m8_t var_31 = __riscv_vle8_v_i8m8(var_49, 113);
// -22, -52, -52, 96, -33, 88, -35, -115, 98, -108, -56, 109, 64, -117, -88, -2, -23, 108, -111, -120, 72, 32, 2, 55, -103, -72, 92, 121, 51, 51, -94, -72, -97, -41, -98, 19, -128, 91, -76, 31, -31, 119, -80, -60, -107, 96, 59, -119, 32, -25, -80, -55, 116, -102, -120, 54, 25, -38, -20, 108, 0, 14, 3, 17, -16, -109, -39, -57, -34, -116, 127, -17, 63, -17, -54, -59, 40, 121, -22, 71, 18, -125, -115, -89, -31, -121, -116, -29, 37, 50, -89, -84, -26, 127, -18, -16, 32, 114, 5, -117, -83, -73, -83, -27, -119, -68, 123, -95, 89, -119, 38, 15, 19

vint8m8_t var_32 = __riscv_vle8_v_i8m8(var_48, 113);
// -75, -8, 2, 9, 84, 7, -73, -74, -76, 116, 102, 38, 92, -72, 44, -56, 116, -104, 114, -47, 89, -79, -117, -76, -6, 8, 94, -27, -55, 102, -64, 48, 92, -105, -43, 73, 7, -1, -65, 54, 108, 88, 54, 73, 93, 7, -12, 41, 26, -44, 29, 41, 28, 61, -42, -68, -62, 53, -27, 43, -112, 122, -80, -36, -32, 106, 44, -1, 31, -125, 78, -7, -41, -74, -85, -42, 123, -18, 56, -56, 73, 36, -112, -3, 26, -119, -3, -30, -82, -52, -95, -85, -13, 49, -57, -88, -66, -26, 10, -124, -86, 87, -6, -60, 53, -59, 20, 127, 30, -100, -46, 36, -86

__riscv_vsetvl_e8m8(62);
vint8m8_t var_33 = __riscv_vle8_v_i8m8(var_47, 62);
// -4, -13, 31, -32, -128, -68, -20, -97, -96, 29, 91, -71, 61, -90, -83, 69, -60, -95, 88, -30, 79, -79, -122, 55, 112, 50, 11, 33, -100, 5, -60, -40, -109, 126, -56, -73, -125, -6, 56, -43, 78, -64, 58, -97, -66, 51, 27, -16, -16, 91, -63, 45, 1, 121, -78, 50, -22, 68, 5, -92, 56, -74

__riscv_vsetvl_e8m8(38);
vint8m8_t var_34 = __riscv_vle8_v_i8m8(var_46, 38);
// -82, 72, 66, -104, -23, -55, 5, 3, 63, -35, -38, 89, -79, -14, -51, -101, -75, -104, -23, 107, -56, 101, -128, 79, 123, 41, 59, 17, 7, 98, 81, 15, 33, 16, -30, 72, 106, 87

__riscv_vsetvl_e8m4(45);
vint8m4_t var_35 = __riscv_vle8_v_i8m4(var_45, 45);
// 56, -64, 44, 61, 4, -87, 4, -59, -123, -18, 103, 25, -118, -21, 57, 92, -57, -53, -3, 15, 127, 93, 71, 116, 124, 37, -73, 82, -113, 97, 63, 85, 67, -83, -31, -62, -15, 46, -10, 76, 14, -73, 37, 88, -53

__riscv_vsetvl_e8m8(113);
vint8m8_t var_36 = __riscv_vle8_v_i8m8(var_44, 113);
// 118, 56, -80, -74, 123, -105, 65, 36, -40, -48, -22, 104, -78, 100, 96, 47, -93, -94, -42, -37, 106, -63, -56, 116, -12, -73, 121, -11, -64, -76, 28, -108, 71, -37, 84, -78, -54, 26, 3, 35, 32, 38, -31, 52, -100, -82, -25, -73, 89, 98, 116, 92, -44, 35, 36, 65, 65, 102, -72, 118, 27, -46, 58, -114, -15, -18, 18, -68, -63, -82, 20, -114, -49, -81, 106, 29, -118, -66, -19, -15, 104, 102, 27, 99, -54, 50, 10, -37, 60, 54, 28, -91, 12, 39, 27, -35, 1, -46, 112, -37, -127, 62, -102, 27, -71, -23, 87, 68, -19, -48, -12, 32, -6

vint8m8_t var_37 = __riscv_vle8_v_i8m8(var_43, 113);
// 32, 57, -12, 44, 99, -31, -100, -34, -80, 77, 23, -69, 125, -46, -40, 54, -85, 53, 23, 5, 77, 7, 36, -54, -51, 61, -55, -104, -12, -94, -90, -41, -95, -101, 49, 89, 7, -116, -117, -41, -93, -30, -92, 15, -74, 81, 88, 56, 72, -20, -88, -76, 84, -12, -88, 122, 93, 97, 8, 85, 127, -64, 120, 29, -17, -87, 115, 13, -37, 91, 47, 12, 15, -57, 65, 34, -30, 29, 111, 107, -90, -8, 58, 41, 118, 17, 71, -12, -24, 15, -82, -23, 54, 98, 119, 106, -20, -19, 77, -120, -13, -52, -13, -107, -45, 66, -110, 63, 116, -18, -110, -46, 36

__riscv_vsetvl_e8m8(45);
vint8m8_t var_38 = __riscv_vle8_v_i8m8(var_42, 45);
// -32, -62, 117, 7, -76, 85, 30, -77, -3, 102, 6, 28, -32, -25, 58, -98, -115, -67, -94, 46, -69, -77, 1, 25, 116, 55, -97, -126, -12, -46, -50, 19, 79, 20, -126, 29, 25, 51, -112, -128, 57, 28, 33, 2, -102

__riscv_vsetvl_e8m8(8);
vint8m8_t var_39 = __riscv_vle8_v_i8m8(var_41, 8);
// 58, 54, -116, -86, 69, -60, 55, -42

__riscv_vsetvl_e8m8(113);
vbool1_t var_19 = __riscv_vmsleu_vx_u8m8_b1(var_20, var_40, 113);
// 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1

__riscv_vsetvl_e64m4(8);
vbool16_t var_21 = __riscv_vmadc_vv_u64m4_b16(var_25, var_26, 8);
// 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

__riscv_vsetvl_e8m8(113);
vbool1_t var_28 = __riscv_vmsle_vv_i8m8_b1(var_31, var_32, 113);
// 0, 1, 1, 0, 1, 0, 0, 1, 0, 1, 1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0, 1, 1, 0, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 1, 1, 0, 1, 0, 1, 0, 1, 0

__riscv_vsetvl_e8m4(45);
int8_t var_12 = __riscv_vmv_x_s_i8m4_i8(var_35);
// 56

__riscv_vsetvl_e8m8(11);
__riscv_vse8_v_i8m8_m(var_19, var_59, var_27, 11);
__riscv_vsetvl_e8mf2(8);
vint8mf2_t var_18 = __riscv_vmul_vv_i8mf2_mu(var_21, var_22, var_23, var_24, 8);
// -22, -26, 48, 5, -12, -43, -120, -120

__riscv_vsetvl_e8m8(113);
vbool1_t var_15 = __riscv_vmsgeu_vv_u8m8_b1_mu(var_19, var_28, var_29, var_30, 113);
// 1, 1, 1, 0, 1, 0, 1, 1, 0, 1, 0, 1, 1, 0, 0, 0, 1, 0, 0, 1, 1, 0, 1, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0

if(!check(var_59, var_89, var_90)) {cerr << "check 88 fails" << endl; return_value = 1;}
__riscv_vsetvl_e8mf2(8);
int8_t var_17 = __riscv_vmv_x_s_i8mf2_i8(var_18);
// -22

__riscv_vsetvl_e8m8(38);
__riscv_vse8_v_i8m8_m(var_15, var_61, var_34, 38);
__riscv_vsetvl_e8m8(62);
__riscv_vse8_v_i8m8_m(var_15, var_60, var_33, 62);
__riscv_vsetvl_e8m8(34);
vbool1_t var_7 = __riscv_vmsof_m_b1_mu(var_15, var_15, var_15, 34);
// 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0

__riscv_vsetvl_e8m8(113);
vint8m8_t var_11 = __riscv_vnmsub_vx_i8m8_mu(var_15, var_36, var_17, var_37, 113);
// 68, 9, 20, -74, -11, -105, 50, -10, -40, 45, -22, -85, -55, 100, 96, 47, -83, -94, -42, -41, 105, -63, 84, -62, -12, -9, 121, -90, -64, 26, 28, -108, 71, -37, 84, -78, 99, -56, 3, 35, 32, 38, -6, -121, -100, -82, 50, -14, 89, 98, -96, -100, -116, -10, 36, 16, 65, 102, -72, 121, 27, -46, 116, -114, -15, 29, 18, 53, -63, -82, 20, 64, -49, -47, 106, 29, -118, 113, -19, -15, 104, 102, 27, -85, -54, 50, 35, -37, 60, -77, 28, -91, 12, 39, -55, -35, 1, -46, -19, -37, 9, 62, -102, -25, -71, 72, 12, 23, -19, -48, -118, 32, -6

if(!check(var_61, var_83, var_84)) {cerr << "check 82 fails" << endl; return_value = 1;}
if(!check(var_60, var_86, var_87)) {cerr << "check 85 fails" << endl; return_value = 1;}
__riscv_vse8_v_i8m8_m(var_15, var_62, var_11, 113);
__riscv_vsetvl_e8m8(45);
vint8m8_t var_10 = __riscv_vmulh_vv_i8m8(var_11, var_38, 45);
// -9, -3, 9, -3, 3, -35, 5, 3, 0, 17, -1, -10, 6, -10, 21, -18, 37, 24, 15, -8, -29, 18, 0, -7, -6, -2, -46, 44, 3, -5, -6, -9, 21, -3, -42, -9, 9, -12, -2, -18, 7, 4, -1, -1, 39

if(!check(var_62, var_80, var_81)) {cerr << "check 79 fails" << endl; return_value = 1;}
vint8m8_t var_8 = __riscv_vasub_vx_i8m8(var_10, var_12, 0, 45);
// -32, -29, -23, -29, -26, -45, -25, -26, -28, -19, -28, -33, -25, -33, -17, -37, -9, -16, -20, -32, -42, -19, -28, -31, -31, -29, -51, -6, -26, -30, -31, -32, -17, -29, -49, -32, -23, -34, -29, -37, -24, -26, -28, -28, -8

__riscv_vse8_v_i8m8_m(var_15, var_63, var_8, 45);
__riscv_vsetvl_e8m8(37);
vbool1_t var_5 = __riscv_vmseq_vv_i8m8_b1_mu(var_15, var_15, var_8, var_10, 37);
// 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0

if(!check(var_63, var_77, var_78)) {cerr << "check 76 fails" << endl; return_value = 1;}
__riscv_vse8_v_i8m8_m(var_5, var_64, var_10, 37);
__riscv_vsetvl_e8m8(34);
vbool1_t var_3 = __riscv_vmorn_mm_b1(var_5, var_7, 34);
// 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1

if(!check(var_64, var_74, var_75)) {cerr << "check 73 fails" << endl; return_value = 1;}
__riscv_vse8_v_i8m8_m(var_3, var_66, var_8, 34);
__riscv_vsetvl_e8m8(8);
vint8m8_t var_2 = __riscv_vadd_vv_i8m8_mu(var_3, var_8, var_11, var_39, 8);
// -32, 63, -96, 96, 58, 91, 105, -52, -28, -19, -28, -33, -25, -33, -17, -37, -9, -16, -20, -32, -42, -19, -28, -31, -31, -29, -51, -6, -26, -30, -31, -32, -17, -29, -49, -32, -23, -34, -29, -37, -24, -26, -28, -28, -8

if(!check(var_66, var_68, var_69)) {cerr << "check 67 fails" << endl; return_value = 1;}
__riscv_vse8_v_i8m8_m(var_3, var_65, var_2, 8);
if(!check(var_65, var_71, var_72)) {cerr << "check 70 fails" << endl; return_value = 1;}
if (return_value)
  __builtin_abort ();
return return_value;
}
