const tests = [
  [-0x10001n, -2n, 0x20002n],
  [-0x10000n, -2n, 0x20000n],
  [-0xffffn, -2n, 0x1fffen],
  [-0xfffen, -2n, 0x1fffcn],
  [-0x8001n, -2n, 0x10002n],
  [-0x8000n, -2n, 0x10000n],
  [-0x7fffn, -2n, 0xfffen],
  [-0x7ffen, -2n, 0xfffcn],
  [-2n, -2n, 4n],
  [-1n, -2n, 2n],
  [0n, -2n, 0n],
  [1n, -2n, -2n],
  [2n, -2n, -4n],
  [0x7ffen, -2n, -0xfffcn],
  [0x7fffn, -2n, -0xfffen],
  [0x8000n, -2n, -0x10000n],
  [0x8001n, -2n, -0x10002n],
  [0xfffen, -2n, -0x1fffcn],
  [0xffffn, -2n, -0x1fffen],
  [0x10000n, -2n, -0x20000n],
  [0x10001n, -2n, -0x20002n],
  [-0x7fffffffn, -1n, 0x7fffffffn],
  [-0x7ffffffen, -1n, 0x7ffffffen],
  [-0x10001n, -1n, 0x10001n],
  [-0x10000n, -1n, 0x10000n],
  [-0xffffn, -1n, 0xffffn],
  [-0xfffen, -1n, 0xfffen],
  [-0x8001n, -1n, 0x8001n],
  [-0x8000n, -1n, 0x8000n],
  [-0x7fffn, -1n, 0x7fffn],
  [-0x7ffen, -1n, 0x7ffen],
  [-1n, -1n, 1n],
  [0n, -1n, 0n],
  [1n, -1n, -1n],
  [2n, -1n, -2n],
  [0x7ffen, -1n, -0x7ffen],
  [0x7fffn, -1n, -0x7fffn],
  [0x8000n, -1n, -0x8000n],
  [0x8001n, -1n, -0x8001n],
  [0xfffen, -1n, -0xfffen],
  [0xffffn, -1n, -0xffffn],
  [0x10000n, -1n, -0x10000n],
  [0x10001n, -1n, -0x10001n],
  [0x7ffffffen, -1n, -0x7ffffffen],
  [0x7fffffffn, -1n, -0x7fffffffn],
  [-0x80000000n, 0n, 0n],
  [-0x7fffffffn, 0n, 0n],
  [-0x7ffffffen, 0n, 0n],
  [-0x10001n, 0n, 0n],
  [-0x10000n, 0n, 0n],
  [-0xffffn, 0n, 0n],
  [-0xfffen, 0n, 0n],
  [-0x8001n, 0n, 0n],
  [-0x8000n, 0n, 0n],
  [-0x7fffn, 0n, 0n],
  [-0x7ffen, 0n, 0n],
  [0n, 0n, 0n],
  [1n, 0n, 0n],
  [2n, 0n, 0n],
  [0x7ffen, 0n, 0n],
  [0x7fffn, 0n, 0n],
  [0x8000n, 0n, 0n],
  [0x8001n, 0n, 0n],
  [0xfffen, 0n, 0n],
  [0xffffn, 0n, 0n],
  [0x10000n, 0n, 0n],
  [0x10001n, 0n, 0n],
  [0x7ffffffen, 0n, 0n],
  [0x7fffffffn, 0n, 0n],
  [-0x80000000n, 1n, -0x80000000n],
  [-0x7fffffffn, 1n, -0x7fffffffn],
  [-0x7ffffffen, 1n, -0x7ffffffen],
  [-0x10001n, 1n, -0x10001n],
  [-0x10000n, 1n, -0x10000n],
  [-0xffffn, 1n, -0xffffn],
  [-0xfffen, 1n, -0xfffen],
  [-0x8001n, 1n, -0x8001n],
  [-0x8000n, 1n, -0x8000n],
  [-0x7fffn, 1n, -0x7fffn],
  [-0x7ffen, 1n, -0x7ffen],
  [1n, 1n, 1n],
  [2n, 1n, 2n],
  [0x7ffen, 1n, 0x7ffen],
  [0x7fffn, 1n, 0x7fffn],
  [0x8000n, 1n, 0x8000n],
  [0x8001n, 1n, 0x8001n],
  [0xfffen, 1n, 0xfffen],
  [0xffffn, 1n, 0xffffn],
  [0x10000n, 1n, 0x10000n],
  [0x10001n, 1n, 0x10001n],
  [0x7ffffffen, 1n, 0x7ffffffen],
  [0x7fffffffn, 1n, 0x7fffffffn],
  [-0x10001n, 2n, -0x20002n],
  [-0x10000n, 2n, -0x20000n],
  [-0xffffn, 2n, -0x1fffen],
  [-0xfffen, 2n, -0x1fffcn],
  [-0x8001n, 2n, -0x10002n],
  [-0x8000n, 2n, -0x10000n],
  [-0x7fffn, 2n, -0xfffen],
  [-0x7ffen, 2n, -0xfffcn],
  [2n, 2n, 4n],
  [0x7ffen, 2n, 0xfffcn],
  [0x7fffn, 2n, 0xfffen],
  [0x8000n, 2n, 0x10000n],
  [0x8001n, 2n, 0x10002n],
  [0xfffen, 2n, 0x1fffcn],
  [0xffffn, 2n, 0x1fffen],
  [0x10000n, 2n, 0x20000n],
  [0x10001n, 2n, 0x20002n],
  [-0x10001n, 0x7ffen, -0x7ffe7ffen],
  [-0x10000n, 0x7ffen, -0x7ffe0000n],
  [-0xffffn, 0x7ffen, -0x7ffd8002n],
  [-0xfffen, 0x7ffen, -0x7ffd0004n],
  [-0x8001n, 0x7ffen, -0x3fff7ffen],
  [-0x8000n, 0x7ffen, -0x3fff0000n],
  [-0x7fffn, 0x7ffen, -0x3ffe8002n],
  [-0x7ffen, 0x7ffen, -0x3ffe0004n],
  [0x7ffen, 0x7ffen, 0x3ffe0004n],
  [0x7fffn, 0x7ffen, 0x3ffe8002n],
  [0x8000n, 0x7ffen, 0x3fff0000n],
  [0x8001n, 0x7ffen, 0x3fff7ffen],
  [0xfffen, 0x7ffen, 0x7ffd0004n],
  [0xffffn, 0x7ffen, 0x7ffd8002n],
  [0x10000n, 0x7ffen, 0x7ffe0000n],
  [0x10001n, 0x7ffen, 0x7ffe7ffen],
  [-0x10001n, 0x7fffn, -0x7fff7fffn],
  [-0x10000n, 0x7fffn, -0x7fff0000n],
  [-0xffffn, 0x7fffn, -0x7ffe8001n],
  [-0xfffen, 0x7fffn, -0x7ffe0002n],
  [-0x8001n, 0x7fffn, -0x3fffffffn],
  [-0x8000n, 0x7fffn, -0x3fff8000n],
  [-0x7fffn, 0x7fffn, -0x3fff0001n],
  [-0x7ffen, 0x7fffn, -0x3ffe8002n],
  [0x7fffn, 0x7fffn, 0x3fff0001n],
  [0x8000n, 0x7fffn, 0x3fff8000n],
  [0x8001n, 0x7fffn, 0x3fffffffn],
  [0xfffen, 0x7fffn, 0x7ffe0002n],
  [0xffffn, 0x7fffn, 0x7ffe8001n],
  [0x10000n, 0x7fffn, 0x7fff0000n],
  [0x10001n, 0x7fffn, 0x7fff7fffn],
  [-0x10000n, 0x8000n, -0x80000000n],
  [-0xffffn, 0x8000n, -0x7fff8000n],
  [-0xfffen, 0x8000n, -0x7fff0000n],
  [-0x8001n, 0x8000n, -0x40008000n],
  [-0x8000n, 0x8000n, -0x40000000n],
  [-0x7fffn, 0x8000n, -0x3fff8000n],
  [-0x7ffen, 0x8000n, -0x3fff0000n],
  [0x8000n, 0x8000n, 0x40000000n],
  [0x8001n, 0x8000n, 0x40008000n],
  [0xfffen, 0x8000n, 0x7fff0000n],
  [0xffffn, 0x8000n, 0x7fff8000n],
  [-0xfffen, 0x8001n, -0x7ffffffen],
  [-0x8001n, 0x8001n, -0x40010001n],
  [-0x8000n, 0x8001n, -0x40008000n],
  [-0x7fffn, 0x8001n, -0x3fffffffn],
  [-0x7ffen, 0x8001n, -0x3fff7ffen],
  [0x8001n, 0x8001n, 0x40010001n],
  [0xfffen, 0x8001n, 0x7ffffffen],
  [-0xfffen, -0x8001n, 0x7ffffffen],
  [-0x8001n, -0x8001n, 0x40010001n],
  [-0x8000n, -0x8001n, 0x40008000n],
  [-0x7fffn, -0x8001n, 0x3fffffffn],
  [-0x7ffen, -0x8001n, 0x3fff7ffen],
  [0xfffen, -0x8001n, -0x7ffffffen],
  [-0xffffn, -0x8000n, 0x7fff8000n],
  [-0xfffen, -0x8000n, 0x7fff0000n],
  [-0x8000n, -0x8000n, 0x40000000n],
  [-0x7fffn, -0x8000n, 0x3fff8000n],
  [-0x7ffen, -0x8000n, 0x3fff0000n],
  [0xfffen, -0x8000n, -0x7fff0000n],
  [0xffffn, -0x8000n, -0x7fff8000n],
  [0x10000n, -0x8000n, -0x80000000n],
  [-0x10001n, -0x7fffn, 0x7fff7fffn],
  [-0x10000n, -0x7fffn, 0x7fff0000n],
  [-0xffffn, -0x7fffn, 0x7ffe8001n],
  [-0xfffen, -0x7fffn, 0x7ffe0002n],
  [-0x7fffn, -0x7fffn, 0x3fff0001n],
  [-0x7ffen, -0x7fffn, 0x3ffe8002n],
  [0xfffen, -0x7fffn, -0x7ffe0002n],
  [0xffffn, -0x7fffn, -0x7ffe8001n],
  [0x10000n, -0x7fffn, -0x7fff0000n],
  [0x10001n, -0x7fffn, -0x7fff7fffn],
  [-0x10001n, -0x7ffen, 0x7ffe7ffen],
  [-0x10000n, -0x7ffen, 0x7ffe0000n],
  [-0xffffn, -0x7ffen, 0x7ffd8002n],
  [-0xfffen, -0x7ffen, 0x7ffd0004n],
  [-0x7ffen, -0x7ffen, 0x3ffe0004n],
  [0xfffen, -0x7ffen, -0x7ffd0004n],
  [0xffffn, -0x7ffen, -0x7ffd8002n],
  [0x10000n, -0x7ffen, -0x7ffe0000n],
  [0x10001n, -0x7ffen, -0x7ffe7ffen],
];

// Cases not covered above.
tests.push(
  // Int32 overflow:
  //
  //   Math.floor(2 ** (Math.log2(2147483648) / 2))
  // = Math.floor(2 ** 15.5)
  // = 46340
  //
  //   Math.ceil(2 ** (Math.log2(2147483648) / 2))
  // = Math.ceil(2 ** 15.5)
  // = 46341
  [46340n, 46340n, 2147395600n],
  [46340n, -46340n, -2147395600n],
  [-46340n, -46340n, 2147395600n],
);

function f(tests) {
  for (let test of tests) {
    let lhs = test[0], rhs = test[1], expected = test[2];
    assertEq(BigInt.asIntN(32, lhs), lhs);
    assertEq(BigInt.asIntN(32, rhs), rhs);
    assertEq(BigInt.asIntN(32, expected), expected);

    let f = Function(`
      let lhs = ${lhs}n;
      let rhs = ${rhs}n;
      assertEq(lhs * rhs, ${expected}n);
      assertEq(rhs * lhs, ${expected}n);
    `);

    for (let j = 0; j < 100; ++j) {
      f();
    }
  }
}

f(tests);
