-- -*-Sql-*- mode (to keep my emacs happy)
--
-- API Package Body for Taxon_Name.
--
-- Scaffold auto-generated by gen-api.pl. gen-api.pl is
-- Copyright 2002-2003 Genomics Institute of the Novartis Research Foundation
-- Copyright 2002-2008 Hilmar Lapp
-- 
--  This file is part of BioSQL.
--
--  BioSQL is free software: you can redistribute it and/or modify it
--  under the terms of the GNU Lesser General Public License as
--  published by the Free Software Foundation, either version 3 of the
--  License, or (at your option) any later version.
--
--  BioSQL is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU Lesser General Public License for more details.
--
--  You should have received a copy of the GNU Lesser General Public License
--  along with BioSQL. If not, see <http://www.gnu.org/licenses/>.
--

CREATE OR REPLACE
PACKAGE BODY Tnm IS

taxon_cached SG_TAXON_NAME.TAX_OID%TYPE DEFAULT NULL;
cache_key VARCHAR2(128) DEFAULT NULL;

CURSOR Tnm_c (
		Tnm_NAME	IN SG_TAXON_NAME.NAME%TYPE,
		Tnm_TAX_OID	IN SG_TAXON_NAME.TAX_OID%TYPE,
		Tnm_NAME_CLASS	IN SG_TAXON_NAME.NAME_CLASS%TYPE)
RETURN SG_TAXON_NAME%ROWTYPE IS
	SELECT t.* FROM SG_TAXON_NAME t
	WHERE
		t.NAME = Tnm_NAME
	AND	t.TAX_OID = NVL(Tnm_TAX_OID,t.TAX_OID)
	AND	t.NAME_CLASS = NVL(Tnm_NAME_CLASS,'scientific name')
	;

FUNCTION get_oid(
		TAX_OID	IN SG_TAXON_NAME.TAX_OID%TYPE DEFAULT NULL,
		Tnm_NAME	IN SG_TAXON_NAME.NAME%TYPE,
		Tnm_NAME_CLASS	IN SG_TAXON_NAME.NAME_CLASS%TYPE,
		Tax_NCBI_TAXON_ID	IN SG_TAXON.NCBI_TAXON_ID%TYPE DEFAULT NULL,
		do_DML		IN NUMBER DEFAULT BSStd.DML_NO)
RETURN SG_TAXON_NAME.TAX_OID%TYPE
IS
	pk	SG_TAXON_NAME.TAX_OID%TYPE DEFAULT NULL;
	Tnm_row Tnm_c%ROWTYPE;
	TAX_OID_	SG_TAXON.OID%TYPE DEFAULT TAX_OID;
	key_str VARCHAR2(128) DEFAULT Tax_OID || '|' || Tax_NCBI_TAXON_ID || '|' || Tnm_Name || '|' || Tnm_Name_Class;
BEGIN
	-- initialize
	-- look up
	IF (pk IS NULL) AND (key_str = cache_key) THEN
	        pk := taxon_cached;
	ELSIF (pk IS NULL) THEN
		-- reset cache
		cache_key := NULL;
		taxon_cached := NULL;
		-- look up foreign key if possible and not provided
		IF (TAX_OID_ IS NULL) AND (Tax_NCBI_TAXON_ID IS NOT NULL) THEN
			TAX_OID_ := Tax.get_oid(
				Tax_NCBI_TAXON_ID => Tax_NCBI_TAXON_ID);
		END IF;
		-- look up
		FOR Tnm_row IN Tnm_c(Tnm_NAME, TAX_OID_, Tnm_NAME_CLASS) LOOP
	        	pk := Tnm_row.Tax_Oid;
			-- cache result
		    	cache_key := key_str;
		    	taxon_cached := pk;
		END LOOP;
	END IF;
	-- insert/update if requested
	IF (pk IS NULL) AND 
	   ((do_DML = BSStd.DML_I) OR (do_DML = BSStd.DML_UI)) THEN
	    	-- look up foreign keys if not provided:
		-- look up SG_TAXON successful?
		IF (TAX_OID_ IS NULL) THEN
			raise_application_error(-20101,
				'failed to look up Tax <' || Tax_NCBI_TAXON_ID || '>');
		END IF;
	    	-- insert the record and obtain the primary key
	    	pk := do_insert(
		        TAX_OID => TAX_OID_,
			NAME => Tnm_NAME,
			NAME_CLASS => Tnm_NAME_CLASS);
	END IF; -- there is no update here
	-- return the foreign key
	RETURN pk;
END;

FUNCTION do_insert(
		TAX_OID	IN SG_TAXON_NAME.TAX_OID%TYPE,
		NAME	IN SG_TAXON_NAME.NAME%TYPE,
		NAME_CLASS	IN SG_TAXON_NAME.NAME_CLASS%TYPE)
RETURN SG_TAXON_NAME.TAX_OID%TYPE 
IS
BEGIN
	-- insert the record
	INSERT INTO SG_TAXON_NAME (
		TAX_OID,
		NAME,
		NAME_CLASS)
	VALUES (
		TAX_OID,
		NAME,
		NAME_CLASS)
	;
	-- return the Taxon foreign key
	RETURN TAX_OID;
END;

FUNCTION collapse_common_names(Tax_Oid IN SG_Taxon_Name.Tax_Oid%TYPE,
	 		       delim   IN VARCHAR2 DEFAULT ', ')
RETURN VARCHAR2
IS
	CURSOR tnm_c(Tax_Oid_ IN SG_Taxon_Name.Tax_Oid%TYPE) IS
		SELECT t.Name FROM SG_Taxon_Name t
		WHERE t.Tax_Oid    = Tax_Oid_
		AND   t.Name_Class = 'common name'
	;
	ans VARCHAR2(256) DEFAULT NULL;
BEGIN
	FOR Tnm_row IN tnm_c(Tax_Oid) LOOP
		IF ans IS NOT NULL THEN
			ans := ans || delim;
		END IF;
		ans := ans || Tnm_row.Name;
	END LOOP;
	RETURN ans;
END;

END Tnm;
/

