# Copyright 2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.15.0

EAPI=8

CRATES="
	aho-corasick@1.1.3
	android_system_properties@0.1.5
	anstream@0.6.20
	anstyle-parse@0.2.7
	anstyle-query@1.1.4
	anstyle-wincon@3.0.10
	anstyle@1.0.13
	anyhow@1.0.100
	atty@0.2.14
	autocfg@1.5.0
	bitflags@2.9.4
	bumpalo@3.19.0
	camino@1.2.1
	cargo-platform@0.1.9
	cargo_metadata@0.15.4
	cc@1.2.39
	cfg-if@1.0.3
	cfg_aliases@0.2.1
	chrono@0.4.42
	clap@4.5.48
	clap_builder@4.5.48
	clap_derive@4.5.47
	clap_lex@0.7.5
	colorchoice@1.0.4
	core-foundation-sys@0.8.7
	errno@0.3.14
	fastrand@2.3.0
	find-msvc-tools@0.1.2
	getrandom@0.3.3
	heck@0.5.0
	hermit-abi@0.1.19
	iana-time-zone-haiku@0.1.2
	iana-time-zone@0.1.64
	is_terminal_polyfill@1.70.1
	itoa@1.0.15
	js-sys@0.3.81
	libbpf-cargo@0.24.8
	libbpf-rs@0.24.8
	libbpf-rs@0.25.0
	libbpf-sys@1.6.1+v1.6.1
	libc@0.2.176
	libudev-sys@0.1.4
	linux-raw-sys@0.11.0
	log@0.4.28
	memchr@2.7.6
	memmap2@0.5.10
	mio@0.8.11
	nix@0.30.1
	num-traits@0.2.19
	once_cell@1.21.3
	once_cell_polyfill@1.70.1
	pkg-config@0.3.32
	proc-macro2@1.0.101
	quote@1.0.41
	r-efi@5.3.0
	regex-automata@0.4.11
	regex-syntax@0.8.6
	regex@1.11.3
	rustix@1.1.2
	rustversion@1.0.22
	ryu@1.0.20
	semver@1.0.27
	serde@1.0.228
	serde_core@1.0.228
	serde_derive@1.0.228
	serde_json@1.0.145
	shlex@1.3.0
	stderrlog@0.5.4
	strsim@0.11.1
	syn@2.0.106
	tempfile@3.23.0
	termcolor@1.1.3
	thiserror-impl@1.0.69
	thiserror@1.0.69
	thread_local@1.1.9
	udev@0.7.0
	unicode-ident@1.0.19
	utf8parse@0.2.2
	vsprintf@2.0.0
	wasi@0.11.1+wasi-snapshot-preview1
	wasi@0.14.7+wasi-0.2.4
	wasip2@1.0.1+wasi-0.2.4
	wasm-bindgen-backend@0.2.104
	wasm-bindgen-macro-support@0.2.104
	wasm-bindgen-macro@0.2.104
	wasm-bindgen-shared@0.2.104
	wasm-bindgen@0.2.104
	winapi-i686-pc-windows-gnu@0.4.0
	winapi-util@0.1.11
	winapi-x86_64-pc-windows-gnu@0.4.0
	winapi@0.3.9
	windows-core@0.62.1
	windows-implement@0.60.1
	windows-interface@0.59.2
	windows-link@0.2.0
	windows-result@0.4.0
	windows-strings@0.5.0
	windows-sys@0.48.0
	windows-sys@0.60.2
	windows-sys@0.61.1
	windows-targets@0.48.5
	windows-targets@0.53.4
	windows_aarch64_gnullvm@0.48.5
	windows_aarch64_gnullvm@0.53.0
	windows_aarch64_msvc@0.48.5
	windows_aarch64_msvc@0.53.0
	windows_i686_gnu@0.48.5
	windows_i686_gnu@0.53.0
	windows_i686_gnullvm@0.53.0
	windows_i686_msvc@0.48.5
	windows_i686_msvc@0.53.0
	windows_x86_64_gnu@0.48.5
	windows_x86_64_gnu@0.53.0
	windows_x86_64_gnullvm@0.48.5
	windows_x86_64_gnullvm@0.53.0
	windows_x86_64_msvc@0.48.5
	windows_x86_64_msvc@0.53.0
	wit-bindgen@0.46.0
"
RUST_MIN_VER="1.82.0"
PYTHON_COMPAT=( python3_{11..14} )

inherit cargo linux-info meson python-any-r1 udev

MY_PV=${PV/_p/-}
MY_P=${PN}-${MY_PV}
DESCRIPTION="Automatic HID-BPF loader based on udev events for device workarounds"
HOMEPAGE="https://libevdev.pages.freedesktop.org/udev-hid-bpf/"
SRC_URI="
	https://gitlab.freedesktop.org/libevdev/udev-hid-bpf/-/archive/${MY_PV}/${MY_P}.tar.bz2
	${CARGO_CRATE_URIS}
"
S="${WORKDIR}"/${MY_P}

LICENSE="GPL-2"
# Dependent crate licenses
LICENSE+="
	BSD-2 MIT Unicode-3.0
	|| ( Apache-2.0 Boost-1.0 )
"
SLOT="0"
KEYWORDS="~amd64"
IUSE="test userhacks"
RESTRICT="!test? ( test )"

DEPEND="
	dev-libs/libbpf:=
	virtual/libudev:=
"
RDEPEND="${DEPEND}"
BDEPEND="
	>=dev-util/bpftool-7.0.0
	llvm-core/clang[llvm_targets_BPF]
	test? (
		$(python_gen_any_dep '
			dev-python/pytest-xdist[${PYTHON_USEDEP}]
		')
	)
"

# BPF
QA_EXECSTACK="
	usr/lib/firmware/hid/bpf/*
	lib/firmware/hid/bpf/*
"

PATCHES=(
	"${FILESDIR}"/${PN}-2.2.0_p20251121-click.patch
	"${FILESDIR}"/${PN}-2.2.0_p20251121-cargo-no-bundled-libbpf.patch
)

python_check_deps() {
	python_has_version "dev-python/pytest-xdist[${PYTHON_USEDEP}]"
}

pkg_pretend() {
	local CONFIG_CHECK="~BPF ~DEBUG_INFO_BTF ~DEBUG_INFO_BTF_MODULES"
	# hidraw: https://docs.kernel.org/hid/hid-bpf.html#tracing
	CONFIG_CHECK+=" ~HID_BPF ~HIDRAW"
	CONFIG_CHECK+=" ~BPF_EVENTS ~TRACING"
	CONFIG_CHECK+=" ~BPF_SYSCALL"

	check_extra_config
}

pkg_setup() {
	use test && python-any-r1_pkg_setup
}

src_configure() {
	# cargo_env vs meson, plus cargo test wants build to be a subdir
	BUILD_DIR="${S}"/build

	local bpf_types=(
		# https://gitlab.freedesktop.org/libevdev/udev-hid-bpf#quirks-user-hack-testing-and-stable
		# 'stable' isn't on by default, but README says:
		#   Distributions that package udev-hid-bpf should package these stable quirks.
		stable
		testing
		$(usev userhacks)
	)

	local emesonargs=(
		# Can't yet use GCC: https://gcc.gnu.org/PR121419
		-Dbpf-compiler=clang
		-Dbpfs="$(IFS=,; echo "${bpf_types[*]}")"
		-Dudevdir="${EPREFIX}$(get_udevdir)"
		$(meson_feature test tests)
	)

	cargo_env meson_src_configure
	ln -s "${CARGO_HOME}" "${BUILD_DIR}/cargo-home" || die
}

src_compile() {
	cargo_env meson_src_compile
}

src_test() {
	# Breakage w/ click-8.3 and mysterious missing _fields_
	local -x PYTEST_ADDOPTS="-k 'not (test_sync_with_kernel_tree.py or TestTUXEDOSirius16Gen1andGen2)'"
	cargo_env meson_src_test
}

src_install() {
	cargo_env meson_src_install

	# BPF objects
	dostrip -x /usr/lib/firmware /lib/firmware
}

pkg_postrm() {
	udev_reload
}

pkg_postinst() {
	udev_reload
}
